#!/bin/sh

#source LAN IP configs
. /app/config/network_lan.ini
. /app/config/network_wan.ini

file1=/etc/openvpn/client/cfg_ip
file2=/etc/openvpn/client/openvpn.up
file3=/etc/openvpn/client/openvpn.down


cfg_file_type=$(sed -n '5p' $file1)

# if EIGRV client config file
#if [ "$cfg_file_type" = "EIGRV_OPENVPN_CLIENT_CONFIG_FILE" ]; then

	# Use ipcalc to get network/cidr for LAN network
	eval $(ipcalc -np $IPADDR_LAN $NETMASK_LAN)
	local_ip=$(echo $NETWORK/$PREFIX)
	# add single quotes to ip address
	local_ip=$(echo -e "'$local_ip'")

	#read cfg_ip to get the vpn_ip and lan ip in the file
	vpn_ip=$(sed -n '3p' $file1)
	
	old_local_ip=$(sed -n '4p' $file1)

	chmod a+w $file1

	# if file is different, update cfg_ip file with current LAN IP
	if [ "$old_local_ip" != "$local_ip" ]; then
		sed -i "4 c $local_ip" $file1
	fi

	#
	# create /etc/openvpn/client/openvpn.up file
	#
	echo '#!/bin/sh' > $file2

	if [ "$VPN_INTERNET_ACCESS" = "YES" ]; then
		echo -e "iptables -t nat -I PREROUTING -d $vpn_ip -i tun0 -j NETMAP --to $local_ip" >> $file2
		echo -e "iptables -t nat -I POSTROUTING -s $local_ip -o tun0 -j NETMAP --to $vpn_ip" >> $file2
	else
		echo -e "iptables -t nat -I PREROUTING -d $vpn_ip -j NETMAP --to $local_ip" >> $file2
		echo -e "iptables -t nat -I POSTROUTING -s $local_ip -j NETMAP --to $vpn_ip" >> $file2
	fi

	#if [ "$VPN_MASQ" = "YES" ]; then
	#	echo 'iptables -t nat -I POSTROUTING -o eth0 -j MASQUERADE' >> $file2
	#fi
	
	echo -e "iptables -A INPUT -i tun+ -j ACCEPT" >> $file2
	echo -e "iptables -A FORWARD -i tun+ -j ACCEPT" >> $file2

	chmod a+x $file2

	#
	# create /etc/openvpn/openvpn.down file
	#
	cp -a $file2 $file3
	sed -i 's/-I/-D/g' $file3
	sed -i 's/-A/-D/g' $file3

#fi

exit 0
