#!/bin/sh

NUM=1
router_request="/tmp/genrsa/r"
router_cert_done="/etc/openvpn/server/rsa/r_IsMade"
pc_request="/tmp/genrsa/p"
pc_cert_done="/etc/openvpn/server/rsa/p_IsMade"
ca_request="/tmp/genrsa/ca"
server_request="/tmp/genrsa/s"
certs_dir="/etc/openvpn/server/rsa/keys"
CFG_VPN_ROUTER_CLIENT_UDP_CONF="/etc/openvpn/server/routerClients-udp.conf"
CFG_VPN_PC_CLIENT_UDP_CONF="/etc/openvpn/server/pcClients-udp.conf"
VPN_SERVER_CONNECTION_CFG="/etc/openvpn/server/vpn_connection_info"

#check if settings change file exists
while [ $NUM -eq 1 ]; do
        # check ca request
        if [ -e $ca_request ]
        then
                . ./vars
                ./clean-all
                ./build-ca
                touch "$router_cert_done/ca"
                rm $ca_request
		#build ta.key
		openvpn --genkey --secret ta.key
		mv ta.key $certs_dir/.
        fi

        # check server request
        if [ -e $server_request ]
        then
                . ./vars
                #read server name
                temp_name=$(cat $server_request)
                export KEY_CN=$temp_name
                export KEY_NAME=$temp_name
                ./build-key-server --batch $temp_name
                touch "$router_cert_done/s"
		#build dh
		./build-dh &
                rm $server_request
        fi

        #check router request files for 1 to 15
        count=1
        while [ $count -lt 16 ]; do
                temp_req=$router_request$count
                if [ -e $temp_req ]
                then
                        . ./vars
                        temp_name=$(sed -n '1p' $temp_req)
                        temp_vpn_ip=$(sed -n '2p' $temp_req)
			temp_vpn_ip=$(echo -e "'$temp_vpn_ip/24'")
                        export KEY_CN=$temp_name
                        export KEY_NAME=$temp_name
                        ./build-key --batch $temp_name

                        #create updated vpn client config file
                        temp_dir=$router_request
                        mkdir $temp_dir
                        #create cfg_ip with client name, server_ip/name, vpn_ip and LAN_IP_TAG
                        echo $temp_name > $temp_dir/cfg_ip
                        cat $VPN_SERVER_CONNECTION_CFG | sed -n '4p' | awk -F= '{ print $2 }' >> $temp_dir/cfg_ip
                        echo $temp_vpn_ip >> $temp_dir/cfg_ip
                        echo "INSERT_ROUTER_LAN_IP_HERE" >> $temp_dir/cfg_ip
			echo "EIGRV_OPENVPN_CLIENT_CONFIG_FILE" >> $temp_dir/cfg_ip

                        # create router client ovpn file
                        cp -a $CFG_VPN_ROUTER_CLIENT_UDP_CONF $temp_dir/$temp_name.ovpn
                        echo "ca \"/etc/openvpn/client/ca.crt\"" >> "$temp_dir/$temp_name.ovpn"
                        echo "cert \"/etc/openvpn/client/$temp_name.crt\"" >> "$temp_dir/$temp_name.ovpn"
                        echo "key \"/etc/openvpn/client/$temp_name.key\"" >> "$temp_dir/$temp_name.ovpn"

                        cp -a $certs_dir/ca.crt $temp_dir/.
			cp -a $certs_dir/ta.key $temp_dir/.
                        cp -a $certs_dir/$temp_name.crt $temp_dir/.
                        cp -a $certs_dir/$temp_name.key $temp_dir/.

                        #create downloadable tgz file
                        cd $temp_dir
                        tar -cvzf $temp_name.tgz ca.crt ta.key cfg_ip $temp_name.crt $temp_name.key $temp_name.ovpn
                        mv $temp_name.tgz $router_cert_done/.
			rm *
                        cd -
                        touch $router_cert_done/$count
                        rm $temp_req
                        rmdir $temp_dir
                fi

                count=$(($count+1))
        done

        #check PC request files for 1 to 15
        count=1
        while [ $count -lt 16 ]; do
                temp_req=$pc_request$count
                if [ -e $temp_req ]
                then
                        . ./vars
                        temp_name=$(sed -n '1p' $temp_req)
                        export KEY_CN=$temp_name
                        export KEY_NAME=$temp_name
                        ./build-key --batch $temp_name

                        #create updated vpn client config file
                        temp_dir=$pc_request
                        mkdir $temp_dir

                        # create pc client ovpn file
                        cp -a $CFG_VPN_PC_CLIENT_UDP_CONF $temp_dir/$temp_name.ovpn
			
			#echo "ca \"ca.crt\"" >> "$temp_dir/$temp_name.ovpn"
			#cp -a $certs_dir/ca.crt $temp_dir/.

			echo "<ca>" >> "$temp_dir/$temp_name.ovpn"                        
			cat $certs_dir/ca.crt >> "$temp_dir/$temp_name.ovpn"
			echo "</ca>" >> "$temp_dir/$temp_name.ovpn"

                        #echo "cert \"$temp_name.crt\"" >> "$temp_dir/$temp_name.ovpn"
                        #cp -a $certs_dir/$temp_name.crt $temp_dir/.
			echo "<cert>" >> "$temp_dir/$temp_name.ovpn"                        
			cat $certs_dir/$temp_name.crt >> "$temp_dir/$temp_name.ovpn"
			echo "</cert>" >> "$temp_dir/$temp_name.ovpn"

                        #echo "key \"$temp_name.key\"" >> "$temp_dir/$temp_name.ovpn"
                        #cp -a $certs_dir/$temp_name.key $temp_dir/.
			echo "<key>" >> "$temp_dir/$temp_name.ovpn"                        
			cat $certs_dir/$temp_name.key >> "$temp_dir/$temp_name.ovpn"
			echo "</key>" >> "$temp_dir/$temp_name.ovpn"
                        
			#cp -a $certs_dir/ta.key $temp_dir/.
			echo "<tls-auth>" >> "$temp_dir/$temp_name.ovpn"                        
			cat $certs_dir/ta.key >> "$temp_dir/$temp_name.ovpn"
			echo "</tls-auth>" >> "$temp_dir/$temp_name.ovpn"


                        #create downloadable tgz file
                        cd $temp_dir
                        #tar -cvzf $temp_name.tgz ca.crt ta.key $temp_name.crt $temp_name.key $temp_name.ovpn
			tar -cvzf $temp_name.tgz $temp_name.ovpn
                        mv $temp_name.tgz $pc_cert_done/.
			rm *
                        cd -
                        touch $pc_cert_done/$count
                        rm $temp_req
                        rmdir $temp_dir
                fi

                count=$(($count+1))
        done

        sleep 5
done
