#!/bin/sh
#
# Here to reload applications.
#
# Need unit and server IP addresses as parameters.
#
if [ $# != 2 ]
then
	echo "Need unit and server IP addresses"
	exit 1
fi

echo "Killing all applications..."
/app/scripts/kill-apps.sh

echo "Starting at root..."
cd /

# Make file system read-write.
#
echo "Making file system read-write..."
/scripts/read-write.sh

# Show what we're using.
#
echo "  Unit IP address is $1"
echo "Server IP address is $2"

# Bring eth0 to known state.
#
echo "Bringing ethernet interface down/up..."
ifconfig eth0 down
ifconfig eth0 $1 up

# Get apps tarball from server.
#
echo "Getting application tarball from server..."
cd /tmp
tftp -g -r apps.tgz $2
cd /

echo "Removing some existing files..."
rm -rf /app/www/*
rm -rf /app/bin/*

echo "Unpacking application tarball..."
tar -xvzf /tmp/apps.tgz

# Remove tar file.
#
echo "Removing tarball..."
rm /tmp/apps.tgz

# Done.
#
echo "Done!"
exit 0
