package Update;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;

import bas_remote.bas_def;

import modbus.mod;
import modbus.mod_def;
import modbus.mod_dev_t;

public class UpdateApplet extends JApplet
{
    /**
	 * 
	 */
	private static final long 	serialVersionUID 	= 1L;
	private String            	hostAddress;
    static boolean            	dbug_on          	= false;
    static String             	dbug_ip          	= "192.168.92.68";
    private mod.device        	comBas        		= new mod.device();

	private JLabel 				errorLabel 			= new JLabel();
	private JButton 			updateButton 		= new JButton();
    private boolean            	update_in_process   = false;

	public UpdateApplet()
	{
		super();
		initComponents();

		final JLabel noteClickUpdateLabel = new JLabel();
		noteClickUpdateLabel.setText("Note: click Update after you load");
		noteClickUpdateLabel.setBounds(10, 0, 245, 24);
		getContentPane().add(noteClickUpdateLabel);

		final JLabel loadTheLabel = new JLabel();
		loadTheLabel.setText("the last file.");
		loadTheLabel.setBounds(10, 18, 156, 14);
		getContentPane().add(loadTheLabel);
	}

	public void init()
	{
		// Get code base string.
		hostAddress = this.getCodeBase().toString().toLowerCase();
		// If forcing the address.
		if (dbug_on == true)
			hostAddress = dbug_ip;
		// Else if executing from local machine.
		else if (hostAddress.startsWith("file"))
			hostAddress = "localhost";
		// Else for real.
		else
		{
			hostAddress = hostAddress.replace("http://", " ");
			hostAddress = hostAddress.replace("/", " ").trim();
		}
        // Connect with host.
        comBas.Connect(hostAddress, mod_dev_t.PORT_TCP, mod_def.PROT_TCP);
        if (!comBas.IsConnected())
        {
            errorLabel.setText("Error: Cannot connect to target");
            errorLabel.setForeground(Color.RED);
            errorLabel.setVisible(true);
        }
	}
	
	public void destroy()
	{
        comBas.Disconnect();		
	}
	
    public void ProcessError( String text )
    {
        mod.err e = mod.err.getObj(text);

        switch (e)
        {
            // We ignore ILLEGAL errors here.
            case ILLEGAL_DATA_ADDRESS:
            case ILLEGAL_FUNCTION:
            case ILLEGAL_DATA_VALUE:
            case ILLEGAL_OBJECT_INSTANCE:
                break;
            default:
                comBas.Disconnect();
                break;
        }
        errorLabel.setText(text);
        errorLabel.setVisible(true);
    }

    private void updateCfg()
    {
        // Ignore this if already updating.
        if ( update_in_process )
            return;
        
        // Set flag. We'll reset this flag at the end of the update,
        // or whenever an error condition is cleared.
        update_in_process = true;

        // Use try/catch.
        try
        {
            // Take unit offline; error if we can't.
            comBas.WriteCfg(bas_def.REG_SYS_OFFLINE, "1");

            // Extend timeout for this operation, then reset to default value.
            comBas.SetTimeout(15000);
            comBas.WriteCfg(bas_def.REG_SYS_FCN, bas_def.FCN_COMMIT);
            comBas.SetTimeout(-1);
            // Clear flag.
            update_in_process = false;
        } catch (IOException e)
        {
            errorLabel.setText("Update failed");
            ProcessError(e.getMessage());
        }
    }

    private void initComponents()
	{
		getContentPane().setLayout(null);
	
		updateButton.setText("Update");
		updateButton.setFont(new Font("Sans", Font.BOLD, 12));
		updateButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				updateCfg();
			}
		});
		updateButton.setBounds(78, 58, 98, 24);
		getContentPane().add(updateButton);

		errorLabel.setBounds(10, 38, 234, 14);
		getContentPane().add(errorLabel);
	}
}
