package MappingCfg;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

import modbus.mod;
import bas_remote.bas_def;

public class modifyPanel extends JPanel
{

	private JTextField EbxConsecutive;
	private JTextField 	EbxModIP;
	private JLabel 		errorLabel;
	private JPanel 		checkPanel;
	private JTextField 	EbxDevInstance;
	private JTextField 	EbxModbusAddr;
	private JTextArea 	EbxDeviceName;
	private JCheckBox	objCheckbox;
    private JScrollPane scrollPane;
	private JPanel 		regPanel;
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
    mod.device        	comBas         	= new mod.device();
    int					obj_qty			= 0;
    String				filename		= null;
    int					objStatus[];
    String				password		= "ccsi2431";
    int					orig_checked_reg = 0;
 	
	public modifyPanel()
	{
        super();
		initComponents();	
		readUserFile();
	}

    int validateIPAddress( String ip )
    {
        int k;
        String[] temp = null;

        // Do the split.
        temp = ip.split("\\.");

        // should have 4 values
        if (temp.length < 4)
            return -1;

        // no whitespace allowed
        for (k = 0; k < 4; k++)
        {
            if (temp[k].length() != temp[k].trim().length())
                return -1;
        }

        if ((temp[0].length() == 0) || (temp[1].length() == 0) || (temp[2].length() == 0) || (temp[3].length() == 0))
            return -1;

        // valid range is 0 to 255
        for (k = 0; k < 4; k++)
        {
            if ((Integer.valueOf(temp[k]).intValue() < 0) || (Integer.valueOf(temp[k]).intValue() > 255))
                return -1;
        }

        return 0;
    }

    public void ProcessError( String text )
    {
        mod.err e = mod.err.getObj(text);

        switch (e)
        {
            // We ignore ILLEGAL errors here.
            case ILLEGAL_DATA_ADDRESS:
            case ILLEGAL_FUNCTION:
            case ILLEGAL_DATA_VALUE:
            case ILLEGAL_OBJECT_INSTANCE:
                break;
            default:
                comBas.Disconnect();
                break;
        }
        errorLabel.setText(text);
        errorLabel.setVisible(true);
    }

    private void writeUserFile() throws Exception
    {
    	String		ip;
        int 		instance, i;
        int			checked_reg = 0;
        String		errorMsg = null;
		boolean 	error = false;
        String		tmp;
        int			result = 0;
        String		modAddr = null;
        int			iModAddr = 0;
        String		comModAddr = null;
		String		modIP = null;
        int			cnt = 0;
        String		rd = null;
        int			rd_group = 0;
        
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        
		if(filename != null)
		{
			fileFunction.unit_name = EbxDeviceName.getText();
	        if(fileFunction.unit_name.equals("") || (fileFunction.unit_name == null))
	        {
	            errorMsg = "Error: No Unit Name!";   
		        JOptionPane.showMessageDialog(null, errorMsg);
		        return;
	        }
			modAddr = EbxModbusAddr.getText();
			iModAddr = Integer.decode(modAddr);
			if((iModAddr > 246) || (iModAddr < 1))
			{
				errorMsg = "Error: wrong modbus address"; 
			}
			else
			{
				modIP = EbxModIP.getText();
            	if(validateIPAddress(modIP) != 0)
            	{
    				errorMsg = "Error: wrong modbus IP address"; 
            	}
            	else
            	{
					if(modIP.equals("0.0.0.0"))
						comModAddr = modAddr;
					else
						comModAddr = modIP.concat(":" + modAddr);
    				// check duplicate modAddr/modIP
    				for(i = 0; i < fileFunction.unit_qty; i++)
    				{
    					if(comModAddr.equals(fileFunction.modbusAddr[i]) && 
    							(fileFunction.unit_index != i))
    					{
            				errorMsg = "Error: Modbus Address already exists";
            				error = true;        						
            				break;
    					}
    				}
    				if(error == true)
    				{
    		        	JOptionPane.showMessageDialog(null, errorMsg);
    		        	return;
    				}
    				else
    				{
    					fileFunction.mod_ip = modIP;
    					fileFunction.mod_address = modAddr;            					
    				}
            		
            		tmp = EbxDevInstance.getText();
            		instance = Integer.decode(tmp);
            		if((instance < 0) || (instance >= 0x3FFFFF))
            		{
            			errorMsg = "Error: wrong device instance";  
            		}
            		else
            		{
        				// check duplicate device instance
        				for(i = 0; i < fileFunction.unit_qty; i++)
        				{
        					if((instance == fileFunction.devInstance[i]) &&
        							(instance != Integer.decode(fileFunction.unit_instance)))        							
        					{
                				errorMsg = "Error: Device Instance already exists";
                				error = true;      
                				break;
        					}
        				}
        				if(error == true)
        				{
        			        // Show status dialog box.
        			    	JOptionPane.showMessageDialog(null, errorMsg);
        			    	return;
        				}
        				fileFunction.unit_instance = tmp;
        				
            			java.awt.Component[] components = regPanel.getComponents();            	
            			for (i = 0; i < components.length; ++i)
            			{
            				JCheckBox cb = (JCheckBox)components[i];
            				if(cb.isSelected())
            				{
            					fileFunction.reg_status[i] = 1;
            					checked_reg++;
            				}
            				else
            					fileFunction.reg_status[i] = 0;                		
            			}
            			
            			if(checked_reg == 0)
            			{
            				errorMsg = "Error: No Register Checked";
            				return;
            			}
            			
            			cnt = fileFunction.total_reg_qty + checked_reg - orig_checked_reg;
            			if(cnt> 1000)
            			{
            				errorMsg = "Error: Mapped registers exceed max limit 1000";			
            		    	JOptionPane.showMessageDialog(null, errorMsg);
            		    	return;
            			}
            			else if(cnt <= 0)
            			{
            				errorMsg = "Error: No registers mapped";			
            		    	JOptionPane.showMessageDialog(null, errorMsg);
            		    	return;            				
            			}
            			
            			rd = EbxConsecutive.getText();
        				fileFunction.consecutive_rd = rd;
        				rd_group = Integer.valueOf(rd);
        				if((rd_group < 1) || (rd_group > fileFunction.MAX_RD))
        				{
         					errorMsg = "Error: Invalid Consecutive Reads";      
            		        JOptionPane.showMessageDialog(null, errorMsg);
            		        return;   					
        				}
        				
            			ip = comBas.ReadCfgStr(bas_def.REG_SYS_IPADDR);
            			if(validateIPAddress(ip) == 0)
            			{
            				result = fileFunction.modifyUserCSVFile(ip, "root", password, filename, null);
            				if(result == 0)
            				{
            					errorMsg = "Modify Device: SUCCESS";
            					fileFunction.modbusAddr[fileFunction.unit_index] = comModAddr;
            					fileFunction.devInstance[fileFunction.unit_index] = instance;
            					fileFunction.total_reg_qty = cnt;
            				}
            				else
            					errorMsg = "Error: Modify Device failed";
            			}
            			else
            				errorMsg = "Error: Can't Modify Settings";
            		} 		
				}
			}
		}
		else
			errorMsg = "Error: No file selected";			
    	JOptionPane.showMessageDialog(null, errorMsg);
    }

    private void readUserFile()
    {
    	String 		objID = null;
        int			i, obj_qty;
        
		// Get object data.
		EbxDeviceName.setText(fileFunction.unit_name);
		EbxModbusAddr.setText(fileFunction.mod_address);
		EbxDevInstance.setText(fileFunction.unit_instance);
		EbxModIP.setText(fileFunction.mod_ip);
		EbxConsecutive.setText(fileFunction.consecutive_rd);
	    obj_qty = fileFunction.reg_qty;
	    objStatus = new int[obj_qty];
        
		// Loop to get all object instances.
        for (i = 0; i < obj_qty; ++i)
        {
        	// Get object instance.
			objID = fileFunction.registers[i];
			objCheckbox = new JCheckBox(objID + "   " + fileFunction.description[i]);
			// Set combo box selection.
			if(fileFunction.reg_status[i] == 0)
				objCheckbox.setSelected(false);    
			else
			{
				objCheckbox.setSelected(true);
				orig_checked_reg++;
			}
			regPanel.add(objCheckbox, i);
		}
        this.validate();
		this.repaint();
    }

    private void initComponents()
    {
		setLayout(null);
		setBounds(10, 10, 469, 475);

		final JLabel nameLabel = new JLabel();
		nameLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		nameLabel.setText("Device Name:");
		nameLabel.setBounds(28, 67, 103, 18);
		add(nameLabel);

		EbxDeviceName = new JTextArea();
		EbxDeviceName.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxDeviceName.setText("EbxDeviceName");
		EbxDeviceName.setBounds(136, 67, 161, 21);
		add(EbxDeviceName);

		final JLabel modbusAddressLabel = new JLabel();
		modbusAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		modbusAddressLabel.setText("Modbus Address:");
		modbusAddressLabel.setBounds(28, 94, 130, 21);
		add(modbusAddressLabel);

		EbxModbusAddr = new JTextField();
		EbxModbusAddr.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxModbusAddr.setText("EbxModbusAddr");
		EbxModbusAddr.setBounds(164, 94, 40, 21);
		add(EbxModbusAddr);

		final JLabel deviceInstanceLabel = new JLabel();
		deviceInstanceLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		deviceInstanceLabel.setText("Device Instance:");
		deviceInstanceLabel.setBounds(28, 143, 120, 21);
		add(deviceInstanceLabel);

		EbxDevInstance = new JTextField();
		EbxDevInstance.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxDevInstance.setText("EbxDevInstance");
		EbxDevInstance.setBounds(153, 143, 144, 21);
		add(EbxDevInstance);

		final JLabel modbusRegistersLabel = new JLabel();
		modbusRegistersLabel.setText("Modbus Registers (Max 1000):");
		modbusRegistersLabel.setBounds(28, 170, 224, 14);
		add(modbusRegistersLabel);

		checkPanel = new JPanel();
		checkPanel.setLayout(null);
		checkPanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		checkPanel.setBounds(28, 190, 332, 216);
		add(checkPanel);

		scrollPane = new JScrollPane();
		scrollPane.setBounds(0, 0, 332, 216);
		checkPanel.add(scrollPane);

		regPanel = new JPanel();
		regPanel.setFont(new Font("Sans", Font.PLAIN, 12));
		regPanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		regPanel.setLayout(new BoxLayout(regPanel, BoxLayout.Y_AXIS));
		regPanel.setBounds(27, 244, 363, 163);
        scrollPane.setViewportView(regPanel);

        errorLabel = new JLabel();
		errorLabel.setForeground(Color.RED);
		errorLabel.setBounds(28, 412, 298, 23);
		add(errorLabel);

		final JButton submitButton = new JButton();
		submitButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				try 
				{
					writeUserFile();
				} 
				catch (Exception e) 
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
		submitButton.setText("Submit");
		submitButton.setBounds(79, 441, 90, 24);
		add(submitButton);

		final JButton cancelButton = new JButton();
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				int		i;
    			java.awt.Component[] components = regPanel.getComponents();
            	
    			for (i = 0; i < components.length; ++i)
    			{
					regPanel.remove(components[i]);
				}
				cmuFlag.set_exit_modify_panel();
			}
		});
		cancelButton.setText("Back");
		cancelButton.setBounds(236, 441, 90, 24);
		add(cancelButton);   	

		final JLabel modifyDeviceLabel = new JLabel();
		modifyDeviceLabel.setForeground(Color.RED);
		modifyDeviceLabel.setFont(new Font("Sans", Font.BOLD, 20));
		modifyDeviceLabel.setText("Modify Device");
		modifyDeviceLabel.setBounds(28, 10, 168, 23);
		add(modifyDeviceLabel);

		final JLabel modbusIpAddressLabel = new JLabel();
		modbusIpAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		modbusIpAddressLabel.setText("Modbus IP Address:");
		modbusIpAddressLabel.setBounds(28, 123, 144, 14);
		add(modbusIpAddressLabel);

		EbxModIP = new JTextField();
		EbxModIP.setText("EbxModIP");
		EbxModIP.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxModIP.setBounds(178, 121, 148, 18);
		add(EbxModIP);
		
		final JLabel label = new JLabel();
		label.setFont(new Font("Sans", Font.PLAIN, 12));
		label.setText("(1 to 246)");
		label.setBounds(210, 97, 77, 14);
		add(label);

		final JLabel consectiveRdLabel = new JLabel();
		consectiveRdLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		consectiveRdLabel.setText("MAX Consecutive RD");
		consectiveRdLabel.setBounds(293, 97, 130, 14);
		add(consectiveRdLabel);

		EbxConsecutive = new JTextField();
		EbxConsecutive.setFont(new Font("Sans", Font.PLAIN, 12));
		EbxConsecutive.setText("1");
		EbxConsecutive.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxConsecutive.setBounds(429, 94, 29, 21);
		add(EbxConsecutive);
    }
}
