/*
 * mod_def.java
 *
 * Created on December 24, 2006, 8:54 AM
 *
 *	Revision History.
 *
 *	4-Mar-2008	RCW
 *
 *	First version for Beta units.
 */

package modbus;

/**
 *
 * @author rcw
 */
public class mod_def
{
    // Maximum number of modbus registers you can read or write
    // in one operation.
    //
    public final static int	    MOD_MAX_REG  = 32;
    public final static int	    MOD_MAX_BYTE = 512;
    //
    // Modbus function numbers.
    //
    public final static byte    MOD_DLE = 0x10;
    public final static byte    MOD_STX = 2;
    public final static byte    MOD_ETX = 3;
    //
    public final static int	    PROT_ASCII = 0;
    public final static int	    PROT_RTU = 1;
    public final static int	    PROT_DF1 = 2;
    public final static int	    PROT_TCP = 3;
    //
    public final static int	    SIZE_16 = 1;
    public final static int	    SIZE_STR = 2;
    //
    public final static int	    READ_COILS = 1;
    public final static int	    READ_DISCRETE_INPUTS = 2;
    public final static int	    READ_HOLDING_REGISTERS = 3;
    public final static int	    READ_INPUT_REGISTERS = 4;
    public final static int	    WRITE_SINGLE_COIL = 5;
    public final static int	    WRITE_SINGLE_REGISTER = 6;
    public final static int	    READ_EXCEPTION_STATUS = 7;
    public final static int	    FETCH_COMM_EVENT_CTR = 11;
    public final static int	    FETCH_COMM_EVENT_LOG = 12;
    public final static int	    WRITE_MULTIPLE_COILS = 15;
    public final static int	    WRITE_MULTIPLE_REGISTERS = 16;
    public final static int	    REPORT_SLAVE_ID = 17;
    public final static int	    READ_GENERAL_REFERENCE = 20;
    public final static int	    WRITE_GENERAL_REFERENCE = 21;
    public final static int	    MASK_WRITE_4X_REGISTER = 22;
    public final static int	    READ_WRITE_4X_REGISTERS = 23;
    public final static int	    READ_FIFO_QUEUE = 24;
    //
    //---Extended functions added by RCW---
    //
    // Notation for extended functions.
    // All values are exchanged big-endian.
    //
    // S  = Slave address.
    // F  = Function.
    // AA = Register address.
    //
    // NU = Not used, encoded as two zero bytes.
    // QQ = Number of registers.
    // CC = Number of data bytes following in request/response.
    // WW     = 16-bit value.
    // DDDD   = 32-bit value.
    // FFFF   = Floating point value.
    // c..c\0 = Null terminated ascii string.
    // b..b   = Binary data.
    //
    public static final int	    RD_REGS_16			=   3;
				    // Req : S F AA QQ
				    // Rsp : S F AA QQ WW WW ...
    public static final int	    WR_REGS_16			=  16;
				    // Req : S F AA QQ WW WW ...
				    // Rsp : S F AA QQ
    public static final int	    RD_REGS_STR			= 100;
				    // Req : S F AA QQ
				    // Rsp : S F AA QQ c..c\0c..c\0...
    public static final int	    WR_REGS_STR			= 101;
				    // Req : S F AA QQ c..c\0c..c\0...
				    // Rsp : S F AA QQ
    public static final int	    RD_REGS_LIST		= 102;
				    // Req : S F NU QQ AA AA AA ...
				    // Rsp : S F NU QQ c..c\0c..c\0...
    public static final int	    WR_REGS_LIST		= 103;
				    // Req : S F NU QQ AAc..c\0AAc..c\0...
				    // Req : S F NU QQ
    //
    // This function is used to relay a message exactly as received
    // to a Modbus compatible device on a serial bus.
    //
    public static final int	    RELAY_MESSAGE		= 104;
				    // Req : S F NU CC ADU
				    // Req : S F NU CC ADU
				    //
				    // ENTRY:
				    // S    = node ID of relay unit.
				    // F    = RELAY_MESSAGE.
				    // NU   = '00'
				    // CC   = number of bytes in request ADU.
				    // ADU  = Modbus request ADU.
				    //
				    // RETURN:
				    // S    = unchanged.
				    // F    = unchanged or |= 0x80 if timeout.
				    // NU   = '00'
				    // CC   = number of bytes in response ADU.
				    // ADU  = Modbus response ADU.
    //
    // This function is used to perform Remote Procedure Calls (RPC).
    // Parameters passed and data returned are all 32-bit values, signed or
    // unsigned as needed by the application.
    // If 'QQ' is a negative number, the data is interpreted as a binary
    // data block, and is not broken up into 4-byte long values.
    //
    public static final int	    MRPC_FCN			= 105;
				    // Req : S F AA QQ DDDD DDDD ...
				    // Rsp : S F AA QQ DDDD DDDD ...
				    //
				    // ENTRY:
				    // S    = Slave address.
				    // F    = MRPC_FCN.
				    // AA   = Function type.
				    // QQ   = Number of 32-bit request parameters.
				    // DDDD = 32-bit request values (or binary data).
				    //
				    // RETURN:
				    // S    = unchanged.
				    // F    = unchanged or |= 0x80 if error.
				    // AA   = Function type.
				    // QQ   = Number of 32-bit response parameters.
				    // DDDD = 32-bit response values (or binary data).
    //
    // Functions used to read/write BACnet object properties.
    // Object properties are always read and written as strings.
    // Does not support all object properties.
    // Object property is never 0; '00' used to terminate property
    // list for read operation (TT).
    // Write operations return a single byte return code for each
    // property written. May be omitted if all operations succeed.
    // Return code will be '0' if success.
    //
    //   QQ = Property Count and Index Flag:
    //        Count is unsigned, with MSBit acting as Index Flag.
    //        If MSBit of count is '0', IIII is object id as described below.
    //        If MSBit of count is '1', IIII is index of object in server object array.
    // IIII = Object id; (BACnetObjectType (Db.h) << 22) + object instance.
    //   PP = BACnet object property (vsbhp.h).
    //    C = Property count (number of properties read/written).
    //    R = Return code if error return:
    //        ILLEGAL_OBJECT_INSTANCE
    //        ILLEGAL_DATA_ADDRESS
    //        ILLEGAL_DATA_VALUE
    //
    public static final int     RD_OBJ              = 106;
                // Req : S F QQ IIII PP PP...
                // Rsp : S F C c..c\0 c..c\0...         (Success)
                // Rsp : S F R                          (Failure)

    public static final int     WR_OBJ              = 107;
                // Req : S F QQ IIII PP c..c\0 PP c..c\0...
                // Rsp : S F C                          (Success)
                // Rsp : S F R                          (Failure)
    //
    // Modbus error codes.
    //
    public final static byte	    ILLEGAL_FUNCTION = 1;
    public final static byte	    ILLEGAL_DATA_ADDRESS = 2;
    public final static byte	    ILLEGAL_DATA_VALUE = 3;
    public final static byte	    SLAVE_DEVICE_FAILURE = 4;
    public final static byte	    ACKNOWLEDGE = 5;
    public final static byte	    SLAVE_DEVICE_BUSY = 6;
    public final static byte	    NEGATIVE_ACKNOWLEDGE = 7;
    public final static byte	    MEMORY_PARITY_ERROR = 8;
    //
    public final static byte	    GATEWAY_NO_PATH = 10;
    public final static byte	    GATEWAY_TIMEOUT = 11;
    //
    public final static byte	    RX_PACKET_CORRUPT = 12;
    public final static byte	    DATA_RX_ERROR = 13;
    public final static byte	    DATA_TX_ERROR = 14;
    public final static byte        ILLEGAL_OBJECT_INSTANCE = 15;
    //
    // Modbus error strings.
    //
    public final static String[]    ErrStr =
    {
        "NULL error code",
        "Illegal Function",
        "Illegal Data Address",
        "Illegal Data Value",
        "Slave Device Failure",
        "Acknowledge",
        "Slave Device Busy",
        "Negative Acknowledge",
        "Memory Parity Error",
        //
        "BAD ERROR CODE",
        //
        "Gateway: No Path",
        "Gateway: Timeout",
        //
        "Received Packet Corrupt",
        "Data Receive Error",
        "Data Transmit Error",
        "Illegal Object Instance",
    };
    /**
	 * Creates a new instance of mod_def
	 */
    public mod_def()
    {
    }
    
}
