package MappingCfg;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import modbus.mod;
import bas_remote.bas_def;

public class addPanel extends JPanel
{

	private JTextField EbxModIpAddr;
	private JTextField EbxRegNumber;
	private JButton 	cancelButton;
	private JButton 	submitButton;
	private JLabel 		errorLabel;
	private JPanel 		checkPanel;
	private JComboBox 	CbxDevType;
	private JTextField 	EbxDevInst;
	private JCheckBox 	CbxAutoInst;
	private JTextField 	EbxModAddr;
	private JTextField 	EbxDevName;
	private JCheckBox	objCheckbox;
    private JScrollPane scrollPane;
	private JPanel 		regPanel;
    //private PopupDialog addStatus;
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	boolean			dbug_on				= false;
	mod.device     	comBas             	= new mod.device();
    int				obj_qty				= 0;
	int				obj_cnt				= 0;
    int				objStatus[];
	String			filename			= "/data/template/";
	String			dstFile				= "/data/map/";
	String			password			= "ccsi2431";
	String			fullName 			= null;
	String			fullDstName 		= null;
	
	public addPanel()
	{
		super();
	    initComponents();

	    if(dbug_on == true)
	    {
	    	final JButton openButton = new JButton();
	    	openButton.addActionListener(new ActionListener() 
	    	{
	    		public void actionPerformed(final ActionEvent event) 
	    		{
	    			int		index = CbxDevType.getSelectedIndex();
			    
	    			try 
	    			{
	    				readTemplateObj(index);
	    			} 
	    			catch (IOException e) 
	    			{
	    				index = 0;
	    				e.printStackTrace();
	    			}
	    		}
	    	});
	    	openButton.setText("Open");
	    	openButton.setBounds(291, 167, 72, 24);
	    	add(openButton);
	    }
	}
	
    int validateIPAddress( String ip )
    {
        int k;
        String[] temp = null;

        // Do the split.
        temp = ip.split("\\.");

        // should have 4 values
        if (temp.length < 4)
            return -1;

        // no whitespace allowed
        for (k = 0; k < 4; k++)
        {
            if (temp[k].length() != temp[k].trim().length())
                return -1;
        }

        if ((temp[0].length() == 0) || (temp[1].length() == 0) || (temp[2].length() == 0) || (temp[3].length() == 0))
            return -1;

        // valid range is 0 to 255
        for (k = 0; k < 4; k++)
        {
            if ((Integer.valueOf(temp[k]).intValue() < 0) || (Integer.valueOf(temp[k]).intValue() > 255))
                return -1;
        }

        return 0;
    }

    public void ProcessError( String text )
    {
        mod.err e = mod.err.getObj(text);

        switch (e)
        {
            // We ignore ILLEGAL errors here.
            case ILLEGAL_DATA_ADDRESS:
            case ILLEGAL_FUNCTION:
            case ILLEGAL_DATA_VALUE:
            case ILLEGAL_OBJECT_INSTANCE:
                break;
            default:
                comBas.Disconnect();
                break;
        }
        errorLabel.setText(text);
        errorLabel.setVisible(true);
    }

    private void readTemplateObj(int index) throws IOException
    {
        String 		objID = null;
        int			i, result = 0;
    	String		name, ip;
    	
    	fileFunction.devType = fileFunction.template_type[index];
    	name = fileFunction.template_filename[index]; 
    	fullName = filename.concat(name);
    	fullDstName = dstFile.concat(name);
    	ip = comBas.ReadCfgStr(bas_def.REG_SYS_IPADDR);
    	result = fileFunction.getTemplateCSVFile(ip, "root", password, fullName);
    	if(result != 0)
    	{
            // Show status dialog box.
        	JOptionPane.showMessageDialog(null, "Error: Can't get data profile");
        	return;
    	}	
    	obj_qty = fileFunction.reg_qty;
	    if(obj_qty > 1000)
	    	obj_qty = 1000;
        objStatus = new int[obj_qty];
        regPanel.removeAll();
		// Loop to get all object instances.
        for (i = 0; i < obj_qty; ++i)
        {
        	
        	// Get object instance.
			objID = fileFunction.registers[i];
			objCheckbox = new JCheckBox(objID + "   " + fileFunction.description[i]);
			// Set combo box selection.
			if(fileFunction.reg_status[i] == 0)
				objCheckbox.setSelected(false);    
			else
				objCheckbox.setSelected(true);
			regPanel.add(objCheckbox);
			obj_cnt++;
		}
        this.validate();
		this.repaint();
    }
    
    private void writeUserFile()
    {
        int			i, instance = 0, regionNumber = 0;
        String		ip, modIP, userFilename = null;
        boolean		error = false;
        int			checked_reg = 0;
        int			reg_cnt = 0;
        String		errorMsg = null;
        int			result = 0;
        String		modAddr = null, reg = null;
        int			iModAddr = 0;
        String		comModAddr = null;
        
        // Return if not connected.
        if (!comBas.IsConnected())
            return;
        // Use try/catch.
        fileFunction.unit_name = EbxDevName.getText();
        if(fileFunction.unit_name.equals("") || (fileFunction.unit_name == null))
        {
            errorMsg = "Error: No Unit Name";   
	        JOptionPane.showMessageDialog(null, errorMsg);
	        return;
        }
        else
        {	
        	modAddr = EbxModAddr.getText();
			fileFunction.mod_address = modAddr;    
			try
			{
				Integer.parseInt(modAddr);
        		iModAddr = Integer.decode(modAddr);
        		if((iModAddr < 1) || (iModAddr > 246))
        		{
        			errorMsg = "Error: Wrong Modbus Address";
    		        JOptionPane.showMessageDialog(null, errorMsg);
    		        return;
        		}
        		else
        		{
        			if(CbxAutoInst.isSelected() == true)
        			{
        				// To do: generate device instance automatically
        				instance = 2450000 + iModAddr;
        				reg = EbxRegNumber.getText();
        				try
        				{
        					Integer.parseInt(reg);
            				regionNumber = Integer.decode(reg);
            				if((regionNumber < 0) || (regionNumber > 10))
            				{
            					errorMsg = "Error: Invalid Region Number"; 
                		        JOptionPane.showMessageDialog(null, errorMsg);
                		        return;
            				}
            				else
            				{
            					instance = instance + regionNumber * 1000;
            					fileFunction.unit_instance = String.valueOf(instance);
                				EbxDevInst.setText(fileFunction.unit_instance);        						
            				}
        				}
        				catch(Exception e)
        				{
        					errorMsg = "Error: Invalid Region Number"; 
            		        JOptionPane.showMessageDialog(null, errorMsg);
            		        return;
        				}
        			}
        			else
        			{
        				fileFunction.unit_instance = EbxDevInst.getText();
        				try
        				{
        					Integer.parseInt(fileFunction.unit_instance);
                        	instance = Integer.decode(fileFunction.unit_instance);
        				}
        				catch(Exception e)
        				{
        					errorMsg = "Error: Invalid Device Instance"; 
            		        JOptionPane.showMessageDialog(null, errorMsg);
            		        return;
        				}
        			}
                		
        			if((instance < 0) || (instance >= 0x3FFFFF))
                	{
                		fileFunction.unit_instance = null;
                		errorMsg = "Error: wrong device instance";   
        		        JOptionPane.showMessageDialog(null, errorMsg);
        		        return;
                	}
        			// check duplicate device instance
        			for(i = 0; i < fileFunction.unit_qty; i++)
        			{
        				if(instance == fileFunction.devInstance[i])
        				{
                			errorMsg = "Error: Device Instance already exists";
                			error = true;      
                			break;
        				}
        			}
        			if(error == true)
        			{
        		        JOptionPane.showMessageDialog(null, errorMsg);
        		        return;
        			}
        			modIP = EbxModIpAddr.getText();
    				fileFunction.mod_ip = modIP;
        			if(validateIPAddress(modIP) == 0)
        			{
						if(modIP.equals("0.0.0.0"))
							comModAddr = modAddr;
						else
							comModAddr = modIP.concat(":" + modAddr);
            			// check duplicate modAddr/modIP
            			for(i = 0; i < fileFunction.unit_qty; i++)
            			{
            				if(comModAddr.equals(fileFunction.modbusAddr[i]))
            				{
                    			errorMsg = "Error: Modbus Address already exists";
                    			error = true;        						
                    			break;
            				}
            			}
            			if(error == true)
            			{
            		        JOptionPane.showMessageDialog(null, errorMsg);
            		        return;
            			}
        			}
        			else
        			{
     					errorMsg = "Error: Invalid Modbus IP Address";      
        		        JOptionPane.showMessageDialog(null, errorMsg);
        		        return;
        			}
        					
        			// write to server
        			if((fullDstName != null) && (error == false))
        			{
        				java.awt.Component[] components = regPanel.getComponents();
        				if(components.length > 1000)
        				{
         					errorMsg = "Error: Number of registers exceeds 1000";      
            		        JOptionPane.showMessageDialog(null, errorMsg);
            		        return;
        				}
        				else
        					reg_cnt = components.length;
        					
        				for (i = 0; i < reg_cnt; ++i)
        				{
        					JCheckBox cb = (JCheckBox)components[i];
        					if(cb.isSelected())
        					{
        						fileFunction.reg_status[i] = 1;
        						checked_reg++;
        					}
        					else
        						fileFunction.reg_status[i] = 0;                		
        				}
        				if(checked_reg > 0)
        				{
        					if((fileFunction.total_reg_qty + checked_reg) > 1000)
        					{
    							errorMsg = "Error: Mapped Registers exceed max limit 1000";	       						
        					}
        					else
        					{
        						if(fileFunction.unit_qty < 30)
        						{
        							ip = comBas.ReadCfgStr(bas_def.REG_SYS_IPADDR);
        							userFilename = fullDstName.replace(".csv", fileFunction.unit_instance);
        							userFilename = userFilename.concat(".csv");
        							result = fileFunction.copyTemplateToUserCSVFile(ip, "root", password, fullName, userFilename);
        							if(result == 0) // success
        							{
        								errorMsg = "Add Device: SUCCESS";
        								fileFunction.modbusAddr[fileFunction.unit_qty] = comModAddr;
        								fileFunction.devInstance[fileFunction.unit_qty] = instance;
        								fileFunction.unit_qty++;
        								fileFunction.total_reg_qty += checked_reg;
        							}
        							else // failure
        								errorMsg = "Error: Add Device failed";	
        						}
        						else
        							errorMsg = "Error: Max number of devices is 30"; 
        					}
        				}
        				else
        					errorMsg = "Error: No Register Checked"; 
        			}
        			else
        			{
        				if(fullDstName == null)
        					errorMsg = "Error: No Template Selected"; 
        			}
        		}
        	}
			catch(Exception e)
			{
				errorMsg = "Error: Invalid Modbus Address"; 
		        JOptionPane.showMessageDialog(null, errorMsg);
		        return;
			}
        }
        JOptionPane.showMessageDialog(null, errorMsg);
	}

	public void reCalculate()
	{
		if(CbxAutoInst.isSelected() == true)
		{
			int		region = 0;
			int 	instance = 0;
			String	mod;
			String	reg;
			
			EbxDevInst.setEnabled(false);
			EbxRegNumber.setEnabled(true);
			mod = EbxModAddr.getText();
			try
			{
				Integer.parseInt(mod);
				instance = 2450000 + Integer.decode(mod);
			}
			catch(Exception e)
			{
				instance = 2450000;						
	        	//JOptionPane.showMessageDialog(null, "Error: Invalid Device Instance");
			}
			reg = EbxRegNumber.getText();
			try
			{
				Integer.parseInt(reg);
				region = Integer.decode(reg);
			}
			catch(Exception e)
			{
				region = 0;
	        	//JOptionPane.showMessageDialog(null, "Error: Invalid Region Number");
			}
			instance = instance + region * 1000;
			EbxDevInst.setText(Integer.toString(instance));
		}
	}

	private void initComponents()
    {
    	int		i;
    	
		setLayout(null);
		setBounds(10, 10, 418, 475);

		final JLabel label = new JLabel();
		label.setFont(new Font("Sans", Font.PLAIN, 12));
		label.setText("(1 to 246)");
		label.setBounds(182, 85, 77, 14);
		add(label);

		final JLabel addDeviceLabel = new JLabel();
		addDeviceLabel.setFont(new Font("Sans", Font.BOLD, 20));
		addDeviceLabel.setForeground(Color.RED);
		addDeviceLabel.setText("Add Device");
		addDeviceLabel.setBounds(27, 10, 138, 22);
		add(addDeviceLabel);

		final JLabel nameLabel = new JLabel();
		nameLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		nameLabel.setText("Name:");
		nameLabel.setBounds(27, 54, 46, 14);
		add(nameLabel);

		EbxDevName = new JTextField();
		EbxDevName.setText("Default Modbus Unit Name");
		EbxDevName.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxDevName.setBounds(77, 50, 220, 22);
		add(EbxDevName);

		final JLabel modbusAddressLabel = new JLabel();
		modbusAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		modbusAddressLabel.setText("Modbus Address:");
		modbusAddressLabel.setBounds(25, 85, 124, 14);
		add(modbusAddressLabel);

		EbxModAddr = new JTextField();
		EbxModAddr.setText("246");
		EbxModAddr.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxModAddr.setBounds(144, 81, 32, 23);
		EbxModAddr.getDocument().addDocumentListener(new DocumentListener()
		{

			@Override
			public void changedUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
				// re-calculate 
				reCalculate();
			}

			@Override
			public void insertUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
				reCalculate();
			}

			@Override
			public void removeUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
				reCalculate();
			}
		});
		add(EbxModAddr);

		EbxDevInst = new JTextField();
		EbxDevInst.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxDevInst.setBounds(158, 168, 110, 22);
		add(EbxDevInst);

		CbxAutoInst = new JCheckBox();
		CbxAutoInst.setFont(new Font("Sans", Font.PLAIN, 12));
		CbxAutoInst.setSelected(true);
		CbxAutoInst.setText("Device Instance Auto");
		CbxAutoInst.setBounds(27, 144, 187, 18);
		add(CbxAutoInst);
		if(CbxAutoInst.isSelected() == true)
		{
			EbxDevInst.setEnabled(false);
			EbxDevInst.setText("2450246");
		}
		else
		{
			EbxDevInst.setEnabled(true);
			EbxDevInst.setText("0");
		}
		CbxAutoInst.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent event) 
			{
				if(CbxAutoInst.isSelected() == true)
				{
					int		region = 0;
					int 	instance = 0;
					String	mod;
					String	reg;
					
					EbxDevInst.setEnabled(false);
					EbxRegNumber.setEnabled(true);
					mod = EbxModAddr.getText();
					try
					{
						Integer.parseInt(mod);
						instance = 2450000 + Integer.decode(mod);
					}
					catch(Exception e)
					{
						instance = 2450000;						
			        	//JOptionPane.showMessageDialog(null, "Error: Invalid Device Instance");
					}
					reg = EbxRegNumber.getText();
					try
					{
						Integer.parseInt(reg);
						region = Integer.decode(reg);
					}
					catch(Exception e)
					{
						region = 0;
			        	//JOptionPane.showMessageDialog(null, "Error: Invalid Region Number");
					}
					instance = instance + region * 1000;
					EbxDevInst.setText(Integer.toString(instance));
				}
				else
				{
					EbxDevInst.setEnabled(true);
					EbxRegNumber.setEnabled(false);
				}
			}
		});

		final JLabel deviceInstanceLabel = new JLabel();
		deviceInstanceLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		deviceInstanceLabel.setText("Device Instance:");
		deviceInstanceLabel.setBounds(27, 172, 124, 14);
		add(deviceInstanceLabel);

		final JLabel deviceTypeLabel = new JLabel();
		deviceTypeLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		deviceTypeLabel.setText("Device Profile:");
		deviceTypeLabel.setBounds(27, 202, 100, 14);
		add(deviceTypeLabel);

		CbxDevType = new JComboBox();
		CbxDevType.setFont(new Font("Sans", Font.PLAIN, 12));
		CbxDevType.setBorder(new BevelBorder(BevelBorder.LOWERED));
		CbxDevType.setBounds(133, 196, 255, 27);
		add(CbxDevType);
        // Clear the box.
		CbxDevType.removeAllItems();
        // Loop to get all object instances.
        for (i = 0; i < fileFunction.template_qty; ++i)
        {
        	// Add object to list.
			CbxDevType.addItem(fileFunction.template_filename[i]);
        }
        CbxDevType.setSelectedIndex(-1);
        
        if(dbug_on == false)
	    {
	    	CbxDevType.addActionListener(new ActionListener() 
	    	{
	    		public void actionPerformed(final ActionEvent event) 
	    		{
	    			JComboBox	cb = (JComboBox)event.getSource();
	    			int			index = cb.getSelectedIndex();
			    
	    			try 
	    			{
	    				readTemplateObj(index);
	    			} 
	    			catch (IOException e) 
	    			{
	    				index = 0;
	    				e.printStackTrace();
	    			}
	    		}
	    	});
	    }
		
		final JLabel registersLabel = new JLabel();
		registersLabel.setText("Modbus Registers (Max 1000):");
		registersLabel.setBounds(25, 222, 227, 16);
		add(registersLabel);

		checkPanel = new JPanel();
		checkPanel.setLayout(null);
		checkPanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		checkPanel.setBounds(27, 244, 363, 163);
		add(checkPanel);

		scrollPane = new JScrollPane();
		scrollPane.setBounds(0, 0, 363, 163);
		checkPanel.add(scrollPane);

		regPanel = new JPanel();
		regPanel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		regPanel.setLayout(new BoxLayout(regPanel, BoxLayout.Y_AXIS));
		regPanel.setBounds(27, 244, 363, 163);
        scrollPane.setViewportView(regPanel);

        errorLabel = new JLabel();
		errorLabel.setForeground(Color.RED);
		errorLabel.setBounds(27, 413, 315, 22);
		add(errorLabel);

		submitButton = new JButton();
		submitButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				errorLabel.setText("");
			    writeUserFile();
			}
		});
		submitButton.setText("Submit");
		submitButton.setBounds(27, 441, 91, 24);
		add(submitButton);

		cancelButton = new JButton();
		cancelButton.addActionListener(new ActionListener() 
		{
			public void actionPerformed(final ActionEvent arg0) 
			{
				int		i;
    			java.awt.Component[] components = regPanel.getComponents();
            	
    			for (i = 0; i < components.length; ++i)
    			{
					regPanel.remove(components[i]);
				}
				cmuFlag.set_exit_add_panel();
			}
		});
		cancelButton.setText("Back");
		cancelButton.setBounds(169, 441, 82, 24);
		add(cancelButton);
		
		final JLabel modbusIpAddressLabel = new JLabel();
		modbusIpAddressLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		modbusIpAddressLabel.setText("Modbus IP Address:");
		modbusIpAddressLabel.setBounds(27, 120, 138, 14);
		add(modbusIpAddressLabel);

		final JLabel regionNumberLabel = new JLabel();
		regionNumberLabel.setFont(new Font("Sans", Font.PLAIN, 12));
		regionNumberLabel.setText("Region Number:");
		regionNumberLabel.setBounds(228, 144, 100, 18);
		add(regionNumberLabel);

		EbxRegNumber = new JTextField();
		EbxRegNumber.setText("0");
		EbxRegNumber.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxRegNumber.setBounds(334, 142, 32, 22);
		EbxRegNumber.getDocument().addDocumentListener(new DocumentListener()
		{

			@Override
			public void changedUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
				// re-calculate 
				reCalculate();
			}

			@Override
			public void insertUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
				reCalculate();
			}

			@Override
			public void removeUpdate(DocumentEvent arg0) 
			{
				// TODO Auto-generated method stub
			}
		});
		add(EbxRegNumber);

		EbxModIpAddr = new JTextField();
		EbxModIpAddr.setText("0.0.0.0");
		EbxModIpAddr.setBorder(new BevelBorder(BevelBorder.LOWERED));
		EbxModIpAddr.setBounds(175, 118, 151, 22);
		add(EbxModIpAddr);
    }

}
