/*
 * Decompiled with CFR 0.152.
 */
package modbus;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import modbus.mod_def;
import modbus.mod_ex;

public class mod_rxtx {
    public static final int CONFIG_ADDRESS = 255;
    static final int MASK8 = 255;
    static final int MASK16 = 65535;
    int BUFFER_SIZE = 128;
    byte protocol = (byte)3;
    byte cur_slv_adr = 1;
    int last_char;
    int rx_length;
    int adu_length;
    byte[] rxBuf;
    byte[] xxBuf;
    byte[] txBuf;
    InputStream dis = null;
    OutputStream dos = null;

    private int BinToTx(int length, byte[] src, byte[] dst) {
        int frame_length = 0;
        int src_idx = 0;
        int dst_idx = 0;
        switch (this.protocol) {
            case 2: {
                dst[dst_idx++] = 16;
                dst[dst_idx++] = 2;
                int i = length;
                while (i > 0) {
                    byte dchar;
                    if ((dchar = src[src_idx++]) == 16) {
                        dst[dst_idx++] = dchar;
                        ++frame_length;
                    }
                    dst[dst_idx++] = dchar;
                    ++frame_length;
                    --i;
                }
                dst[dst_idx++] = 16;
                dst[dst_idx++] = 3;
                frame_length += 4;
                break;
            }
            case 3: {
                System.arraycopy(src, 0, dst, 0, length);
                frame_length = length;
                break;
            }
        }
        return frame_length;
    }

    private int RxToBin(int length, byte[] src, byte[] dst) {
        int frame_length = 0;
        switch (this.protocol) {
            case 2: {
                if (src[0] != 16) {
                    return -1;
                }
                if (src[1] != 2) {
                    return -1;
                }
                int src_idx = 2;
                int dst_idx = 0;
                boolean end_of_packet = false;
                int last_chr = 0;
                int i = length -= 2;
                while (i-- > 0) {
                    int this_chr = src[src_idx++];
                    if (last_chr == 16) {
                        if (this_chr == 16) {
                            dst[dst_idx++] = 16;
                            --length;
                            last_chr = 0;
                            continue;
                        }
                        if (this_chr == 3) {
                            if (i != 0) {
                                return -1;
                            }
                            end_of_packet = true;
                            continue;
                        }
                        return -1;
                    }
                    if (this_chr == 16) {
                        last_chr = 16;
                        continue;
                    }
                    dst[dst_idx++] = this_chr;
                    last_chr = this_chr;
                }
                if (!end_of_packet) {
                    return -1;
                }
                frame_length = length - 2;
                break;
            }
            case 3: {
                frame_length = length;
                System.arraycopy(src, 0, dst, 0, length);
                break;
            }
        }
        return frame_length;
    }

    private void ResetRx() {
        this.last_char = 0;
        this.rx_length = 0;
        this.adu_length = 0;
    }

    private int RxChar(int dchar) {
        if (this.rx_length >= this.BUFFER_SIZE) {
            this.ResetRx();
            return -1;
        }
        this.rxBuf[this.rx_length++] = (byte)dchar;
        block0 : switch (this.protocol) {
            case 2: {
                switch (this.rx_length) {
                    case 1: {
                        if (dchar == 16) break block0;
                        this.rx_length = 0;
                        dchar = 0;
                        break block0;
                    }
                    case 2: {
                        if (dchar == 2) break block0;
                        this.rx_length = 0;
                        dchar = 0;
                        break block0;
                    }
                }
                if (this.last_char != 16) break;
                if (dchar == 16) {
                    dchar = 0;
                    break;
                }
                if (dchar != 3) break;
                return this.rx_length;
            }
            case 3: {
                if (this.adu_length == 0) {
                    if (this.rx_length != 6) break;
                    this.adu_length = (this.rxBuf[4] & 0xFF) << 8;
                    this.adu_length += this.rxBuf[5] & 0xFF;
                    this.adu_length += 6;
                    break;
                }
                if (this.rx_length < this.adu_length) break;
                return this.rx_length;
            }
        }
        this.last_char = dchar;
        return 0;
    }

    private int WaitPacket() {
        int dchar;
        this.ResetRx();
        do {
            try {
                dchar = this.dis.read();
            }
            catch (IOException e) {
                return -1;
            }
            dchar = this.RxChar(dchar);
            if (dchar >= 0) continue;
            this.ResetRx();
            return -1;
        } while (dchar == 0);
        return this.rx_length;
    }

    private int BytesToString(byte[] src, int b_idx, mod_ex mex, int s_idx) {
        byte dchar;
        mex.s[s_idx] = "";
        while ((dchar = src[b_idx++]) != 0) {
            int n = s_idx;
            mex.s[n] = String.valueOf(mex.s[n]) + Character.toString((char)dchar);
        }
        return b_idx;
    }

    private int StringToBytes(byte[] dst, int b_idx, mod_ex mex, int s_idx) {
        int length = mex.s[s_idx].length();
        int i = 0;
        while (i < length) {
            dst[b_idx++] = (byte)mex.s[s_idx].charAt(i);
            ++i;
        }
        dst[b_idx++] = 0;
        return b_idx;
    }

    public int MasterTx(mod_ex mex) {
        int frame_length;
        int i;
        byte byte_msk;
        int tmpval = 0;
        try {
            tmpval = this.dis.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (tmpval != 0) {
            try {
                this.dis.read(this.xxBuf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int xx_idx = 0;
        int rx_idx = 0;
        if (this.protocol == 3) {
            this.xxBuf[xx_idx++] = (byte)(mex.tran_id >> 8);
            this.xxBuf[xx_idx++] = (byte)mex.tran_id;
            this.xxBuf[xx_idx++] = (byte)(mex.prot_id >> 8);
            this.xxBuf[xx_idx++] = (byte)mex.prot_id;
            xx_idx += 2;
        }
        this.xxBuf[xx_idx++] = mex.slv_adr;
        this.xxBuf[xx_idx++] = mex.fcn;
        tmpval = mex.itm_adr - 1;
        this.xxBuf[xx_idx++] = (byte)(tmpval >> 8);
        this.xxBuf[xx_idx++] = (byte)tmpval;
        switch (mex.fcn) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.xxBuf[xx_idx++] = (byte)(mex.itm_qty >> 8);
                this.xxBuf[xx_idx++] = (byte)mex.itm_qty;
                break;
            }
            case 5: {
                tmpval = mex.b[0] != 0 ? 65280 : 0;
                this.xxBuf[xx_idx++] = (byte)(tmpval >> 8);
                this.xxBuf[xx_idx++] = (byte)tmpval;
                break;
            }
            case 6: {
                this.xxBuf[xx_idx++] = (byte)(mex.w[0] >> 8);
                this.xxBuf[xx_idx++] = (byte)mex.w[0];
                break;
            }
            case 15: {
                this.xxBuf[xx_idx++] = (byte)(mex.itm_qty >> 8);
                this.xxBuf[xx_idx++] = (byte)mex.itm_qty;
                byte byte_cnt = (byte)(mex.itm_qty / 8);
                if ((mex.itm_qty & 7) != 0) {
                    byte_cnt = (byte)(byte_cnt + 1);
                }
                this.xxBuf[xx_idx++] = byte_cnt;
                byte byte_val = 0;
                byte_msk = 1;
                i = 0;
                while (i < mex.itm_qty) {
                    if (mex.b[i] != 0) {
                        byte_val = (byte)(byte_val | byte_msk);
                    }
                    if (byte_msk == 128) {
                        this.xxBuf[xx_idx++] = byte_val;
                        byte_val = 0;
                        byte_msk = 1;
                        byte_cnt = (byte)(byte_cnt - 1);
                    } else {
                        byte_msk = (byte)(byte_msk << 1);
                    }
                    ++i;
                }
                if (byte_cnt == 0) break;
                this.xxBuf[xx_idx++] = byte_val;
                break;
            }
            case 16: {
                this.xxBuf[xx_idx++] = (byte)(mex.itm_qty >> 8);
                this.xxBuf[xx_idx++] = (byte)mex.itm_qty;
                this.xxBuf[xx_idx++] = (byte)(mex.itm_qty * 2);
                i = 0;
                while (i < mex.itm_qty) {
                    this.xxBuf[xx_idx++] = (byte)(mex.w[i] >> 8);
                    this.xxBuf[xx_idx++] = (byte)mex.w[i];
                    ++i;
                }
                break;
            }
            case 100: {
                this.xxBuf[xx_idx++] = (byte)(mex.itm_qty >> 8);
                this.xxBuf[xx_idx++] = (byte)mex.itm_qty;
                break;
            }
            case 101: {
                this.xxBuf[xx_idx++] = (byte)(mex.itm_qty >> 8);
                this.xxBuf[xx_idx++] = (byte)mex.itm_qty;
                i = 0;
                while (i < mex.itm_qty) {
                    xx_idx = this.StringToBytes(this.xxBuf, xx_idx, mex, i);
                    ++i;
                }
                break;
            }
            case 105: {
                this.xxBuf[xx_idx++] = (byte)(mex.itm_qty >> 8);
                this.xxBuf[xx_idx++] = (byte)mex.itm_qty;
                i = 0;
                while (i < mex.itm_qty) {
                    this.xxBuf[xx_idx++] = (byte)(mex.l[i] >> 24);
                    this.xxBuf[xx_idx++] = (byte)(mex.l[i] >> 16);
                    this.xxBuf[xx_idx++] = (byte)(mex.l[i] >> 8);
                    this.xxBuf[xx_idx++] = (byte)mex.l[i];
                    ++i;
                }
                break;
            }
            case 102: {
                this.xxBuf[xx_idx++] = (byte)(mex.itm_qty >> 8);
                this.xxBuf[xx_idx++] = (byte)mex.itm_qty;
                i = 0;
                while (i < mex.itm_qty) {
                    this.xxBuf[xx_idx++] = (byte)(mex.w[i] >> 8);
                    this.xxBuf[xx_idx++] = (byte)mex.w[i];
                    ++i;
                }
                break;
            }
            case 106: 
            case 107: {
                mex.itm_qty = (short)(mex.itm_adr & Short.MAX_VALUE);
                this.xxBuf[xx_idx++] = (byte)(mex.l[0] >> 24);
                this.xxBuf[xx_idx++] = (byte)(mex.l[0] >> 16);
                this.xxBuf[xx_idx++] = (byte)(mex.l[0] >> 8);
                this.xxBuf[xx_idx++] = (byte)mex.l[0];
                i = 0;
                while (i < mex.itm_qty) {
                    this.xxBuf[xx_idx++] = (byte)(mex.w[i] >> 8);
                    this.xxBuf[xx_idx++] = (byte)mex.w[i];
                    if (mex.fcn == 107) {
                        xx_idx = this.StringToBytes(this.xxBuf, xx_idx, mex, i);
                    }
                    ++i;
                }
                break;
            }
            default: {
                mex.fcn = (byte)(mex.fcn | 0x80);
                mex.b[0] = 1;
                return -1;
            }
        }
        if (this.protocol == 3) {
            frame_length = xx_idx - 6;
            this.xxBuf[4] = (byte)(frame_length >> 8);
            this.xxBuf[5] = (byte)frame_length;
        }
        frame_length = this.BinToTx(xx_idx, this.xxBuf, this.txBuf);
        try {
            this.dos.write(this.txBuf, 0, frame_length);
        }
        catch (IOException e) {
            if (mex.fcn == 102) {
                mex.s[0] = mod_def.ErrStr[14];
            } else {
                mex.b[0] = 14;
            }
            mex.fcn = (byte)(mex.fcn | 0x80);
            return -1;
        }
        if (mex.slv_adr == 0) {
            return 0;
        }
        frame_length = this.WaitPacket();
        if (frame_length == -1) {
            if (mex.fcn == 102) {
                mex.s[0] = mod_def.ErrStr[13];
            } else {
                mex.b[0] = 13;
            }
            mex.fcn = (byte)(mex.fcn | 0x80);
            return -1;
        }
        frame_length = this.RxToBin(frame_length, this.rxBuf, this.rxBuf);
        rx_idx = 0;
        if (this.protocol == 3) {
            mex.tran_id = (short)(this.rxBuf[rx_idx++] << 8);
            mex.tran_id = (short)(mex.tran_id | this.rxBuf[rx_idx++] & 0xFF);
            mex.prot_id = (short)(this.rxBuf[rx_idx++] << 8);
            mex.prot_id = (short)(mex.prot_id | this.rxBuf[rx_idx++] & 0xFF);
            mex.mbap_len = (short)(this.rxBuf[rx_idx++] << 8);
            mex.mbap_len = (short)(mex.mbap_len | this.rxBuf[rx_idx++] & 0xFF);
        }
        mex.slv_adr = this.rxBuf[rx_idx++];
        mex.fcn = this.rxBuf[rx_idx++];
        if ((mex.fcn & 0x80) != 0) {
            if ((mex.fcn & 0x7F) != 102) {
                mex.b[0] = this.rxBuf[rx_idx];
            }
            return -1;
        }
        switch (mex.fcn) {
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                break;
            }
            case 1: 
            case 2: {
                ++rx_idx;
                byte_msk = 1;
                i = 0;
                while (i < mex.itm_qty) {
                    mex.b[i] = (this.rxBuf[rx_idx] & byte_msk) != 0 ? (byte)1 : 0;
                    if (byte_msk == 128) {
                        ++rx_idx;
                        byte_msk = 1;
                    } else {
                        byte_msk = (byte)(byte_msk << 1);
                    }
                    ++i;
                }
                break;
            }
            case 3: 
            case 4: {
                ++rx_idx;
                i = 0;
                while (i < mex.itm_qty) {
                    mex.w[i] = (short)(this.rxBuf[rx_idx++] << 8);
                    int n = i++;
                    mex.w[n] = (short)(mex.w[n] | this.rxBuf[rx_idx++] & 0xFF);
                }
                break;
            }
            case 100: 
            case 102: {
                rx_idx += 2;
                mex.itm_qty = (short)(this.rxBuf[rx_idx++] << 8);
                mex.itm_qty = (short)(mex.itm_qty | this.rxBuf[rx_idx++] & 0xFF);
                i = 0;
                while (i < mex.itm_qty) {
                    rx_idx = this.BytesToString(this.rxBuf, rx_idx, mex, i);
                    ++i;
                }
                break;
            }
            case 101: {
                break;
            }
            case 105: {
                rx_idx += 2;
                mex.itm_qty = (short)(this.rxBuf[rx_idx++] << 8);
                mex.itm_qty = (short)(mex.itm_qty | this.rxBuf[rx_idx++] & 0xFF);
                i = 0;
                while (i < mex.itm_qty) {
                    mex.l[i] = this.rxBuf[rx_idx++] << 24 & 0xFF000000;
                    int n = i;
                    mex.l[n] = mex.l[n] | this.rxBuf[rx_idx++] << 16 & 0xFF0000;
                    int n2 = i;
                    mex.l[n2] = mex.l[n2] | this.rxBuf[rx_idx++] << 8 & 0xFF00;
                    int n3 = i++;
                    mex.l[n3] = mex.l[n3] | this.rxBuf[rx_idx++] & 0xFF;
                }
                break;
            }
            case 106: 
            case 107: {
                if (mex.fcn == 107) break;
                mex.itm_qty = this.rxBuf[rx_idx++];
                i = 0;
                while (i < mex.itm_qty) {
                    rx_idx = this.BytesToString(this.rxBuf, rx_idx, mex, i);
                    ++i;
                }
                break;
            }
        }
        return 0;
    }

    public int ReadReg16(mod_ex mex, int chn, int reg) {
        mex.slv_adr = this.cur_slv_adr;
        mex.fcn = (byte)3;
        mex.itm_adr = (short)mex.RegIdx(chn, reg);
        mex.itm_qty = 1;
        this.MasterTx(mex);
        return mex.w[0];
    }

    public int ReadReg16(mod_ex mex, int reg) {
        mex.slv_adr = this.cur_slv_adr;
        mex.fcn = (byte)3;
        mex.itm_adr = (short)reg;
        mex.itm_qty = 1;
        this.MasterTx(mex);
        return mex.w[0];
    }

    public int WriteReg16(mod_ex mex, int chn, int reg, int value) {
        mex.slv_adr = this.cur_slv_adr;
        mex.fcn = (byte)16;
        mex.itm_adr = (short)mex.RegIdx(chn, reg);
        mex.itm_qty = 1;
        mex.w[0] = (short)value;
        return this.MasterTx(mex);
    }

    public int WriteReg16(mod_ex mex, int reg, int value) {
        mex.slv_adr = this.cur_slv_adr;
        mex.fcn = (byte)16;
        mex.itm_adr = (short)reg;
        mex.itm_qty = 1;
        mex.w[0] = (short)value;
        return this.MasterTx(mex);
    }

    public int ReadString(mod_ex mex, int chn, int reg) {
        mex.slv_adr = this.cur_slv_adr;
        mex.fcn = (byte)100;
        mex.itm_adr = (short)mex.RegIdx(chn, reg);
        mex.itm_qty = 1;
        return this.MasterTx(mex);
    }

    public int ReadString(mod_ex mex, int reg) {
        mex.slv_adr = this.cur_slv_adr;
        mex.fcn = (byte)100;
        mex.itm_adr = (short)reg;
        mex.itm_qty = 1;
        return this.MasterTx(mex);
    }

    public int WriteString(mod_ex mex, int chn, int reg, String val) {
        mex.slv_adr = this.cur_slv_adr;
        mex.fcn = (byte)101;
        mex.itm_adr = (short)mex.RegIdx(chn, reg);
        mex.itm_qty = 1;
        mex.s[0] = val;
        return this.MasterTx(mex);
    }

    public int WriteString(mod_ex mex, int reg, String val) {
        mex.slv_adr = this.cur_slv_adr;
        mex.fcn = (byte)101;
        mex.itm_adr = (short)reg;
        mex.itm_qty = 1;
        mex.s[0] = val;
        return this.MasterTx(mex);
    }

    public boolean ReadBool(mod_ex mex, int chn, int reg) {
        this.ReadString(mex, chn, reg);
        return !mex.s[0].equals("0");
    }

    public boolean ReadBool(mod_ex mex, int reg) {
        this.ReadString(mex, reg);
        return !mex.s[0].equals("0");
    }

    public int WriteBool(mod_ex mex, int chn, int reg, boolean val) {
        if (val) {
            return this.WriteString(mex, chn, reg, "1");
        }
        return this.WriteString(mex, chn, reg, "0");
    }

    public int WriteBool(mod_ex mex, int reg, boolean val) {
        if (val) {
            return this.WriteString(mex, reg, "1");
        }
        return this.WriteString(mex, reg, "0");
    }

    public int ReadInt(mod_ex mex, int chn, int reg) {
        this.ReadString(mex, chn, reg);
        return Integer.parseInt(mex.s[0]);
    }

    public int ReadInt(mod_ex mex, int reg) {
        this.ReadString(mex, reg);
        return Integer.parseInt(mex.s[0]);
    }

    public int WriteInt(mod_ex mex, int chn, int reg, int val) {
        return this.WriteString(mex, chn, reg, Integer.toString(val));
    }

    public int WriteInt(mod_ex mex, int reg, int val) {
        return this.WriteString(mex, reg, Integer.toString(val));
    }

    public float ReadFloat(mod_ex mex, int chn, int reg) {
        this.ReadString(mex, chn, reg);
        return Float.parseFloat(mex.s[0]);
    }

    public float ReadFloat(mod_ex mex, int reg) {
        this.ReadString(mex, reg);
        return Float.parseFloat(mex.s[0]);
    }

    public int WriteFloat(mod_ex mex, int chn, int reg, float val) {
        return this.WriteString(mex, chn, reg, Float.toString(val));
    }

    public int WriteFloat(mod_ex mex, int reg, float val) {
        return this.WriteString(mex, reg, Float.toString(val));
    }

    public String ReadReg(mod_ex mex, int chn, int reg) {
        this.ReadString(mex, chn, reg);
        return mex.s[0];
    }

    public String ReadReg(mod_ex mex, int reg) {
        this.ReadString(mex, reg);
        return mex.s[0];
    }

    public int WriteReg(mod_ex mex, int chn, int reg, String val) {
        return this.WriteString(mex, chn, reg, val);
    }

    public int WriteReg(mod_ex mex, int reg, String val) {
        return this.WriteString(mex, reg, val);
    }

    public int ReadRegList(mod_ex mex, int qty) {
        mex.slv_adr = this.cur_slv_adr;
        mex.fcn = (byte)102;
        mex.itm_adr = 0;
        mex.itm_qty = (short)qty;
        return this.MasterTx(mex);
    }

    public String ReadCfgReg(mod_ex mex, int reg) {
        mex.slv_adr = (byte)-1;
        mex.fcn = (byte)100;
        mex.itm_adr = (short)reg;
        mex.itm_qty = 1;
        if (this.MasterTx(mex) == 0) {
            return mex.s[0];
        }
        return "ERROR";
    }

    public int WriteCfgReg(mod_ex mex, int reg, String val) {
        mex.slv_adr = (byte)-1;
        mex.fcn = (byte)101;
        mex.itm_adr = (short)reg;
        mex.itm_qty = 1;
        mex.s[0] = val;
        return this.MasterTx(mex);
    }

    public int WriteCfgReg(mod_ex mex, int reg, int val) {
        mex.slv_adr = (byte)-1;
        mex.fcn = (byte)101;
        mex.itm_adr = (short)reg;
        mex.itm_qty = 1;
        mex.s[0] = Integer.toString(val);
        return this.MasterTx(mex);
    }

    public int ReadObj(mod_ex mex, boolean idx_flag, int obj_instance, int obj_property, String val) {
        mex.slv_adr = (byte)-1;
        mex.fcn = (byte)106;
        mex.itm_adr = idx_flag ? (short)-32767 : (short)1;
        mex.itm_qty = 1;
        mex.l[0] = obj_instance;
        mex.w[0] = (short)obj_property;
        if (this.MasterTx(mex) == 0) {
            val = mex.s[0];
            return 0;
        }
        return mex.b[0];
    }

    public int WriteObj(mod_ex mex, boolean idx_flag, int obj_instance, int obj_property, String val) {
        mex.slv_adr = (byte)-1;
        mex.fcn = (byte)107;
        mex.itm_adr = idx_flag ? (short)-32767 : (short)1;
        mex.itm_qty = 1;
        mex.l[0] = obj_instance;
        mex.w[0] = (short)obj_property;
        mex.s[0] = val;
        if (this.MasterTx(mex) == 0) {
            return 0;
        }
        return mex.b[0];
    }

    public boolean StrToBool(String val) {
        return val.equals("1");
    }

    public String BoolToStr(boolean val) {
        if (val) {
            return "1";
        }
        return "0";
    }

    public void SetProtocol(byte mod_protocol) {
        this.protocol = mod_protocol;
    }

    public int GetProtocol() {
        return this.protocol;
    }

    public void SetSlaveAddress(byte address) {
        this.cur_slv_adr = address;
    }

    public byte GetSlaveAddress() {
        return this.cur_slv_adr;
    }

    public mod_rxtx(InputStream is, OutputStream os) {
        this.dis = is;
        this.dos = os;
        this.rxBuf = new byte[this.BUFFER_SIZE];
        this.xxBuf = new byte[this.BUFFER_SIZE];
        this.txBuf = new byte[this.BUFFER_SIZE];
    }

    public int ReadPacket(byte[] buf) throws IOException {
        int rxlen = this.dis.read(buf);
        return rxlen;
    }
}

