// SrvrDlg.cpp : implementation file
//

#include "stdafx.h"
#include "arcview.h"
#include "SrvrDlg.h"
#include "globals.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSrvrDlg dialog


CSrvrDlg::CSrvrDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSrvrDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSrvrDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CSrvrDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSrvrDlg)
	DDX_Control(pDX, IDC_AUTODETECT, m_AutoDetect);
	DDX_Control(pDX, IDC_PORT, m_Port);
	DDX_Control(pDX, IDC_IPADDRESS, m_IPAddress);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSrvrDlg, CDialog)
	//{{AFX_MSG_MAP(CSrvrDlg)
	ON_BN_CLICKED(IDC_AUTODETECT, OnAutodetect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSrvrDlg message handlers

BOOL CSrvrDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_IPAddress.EnableWindow( FALSE );
	m_Port.EnableWindow( FALSE );
	SetDlgItemText( IDC_PORT , "5001" );
	m_AutoDetect.SetCheck( TRUE );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSrvrDlg::OnAutodetect() 
{
	if ( m_AutoDetect.GetCheck() )
	{
		m_IPAddress.EnableWindow( FALSE );
		m_Port.EnableWindow( FALSE );
		SetDlgItemText( IDC_PORT , "5001" );
		SetDlgItemText( IDC_IPADDRESS , "" );
	}
	else
	{
		m_IPAddress.EnableWindow( TRUE );
		m_Port.EnableWindow( TRUE );
	}
}

void CSrvrDlg::OnOK() 
{
	// If we've selected auto-detect.
	if ( m_AutoDetect.GetCheck() )
	{
		gHostname = "";
		gHostPort = 5001;
	}
	else
	{
		m_IPAddress.GetWindowText( gHostname );
		gHostPort = GetDlgItemInt( IDC_PORT );
	}

	CDialog::OnOK();
}
