#ifndef		GLOBALS_H
#define		GLOBALS_H

#ifndef		ARCX_H
#include	"ArcX.h"
#endif
//
// COM20020 register addresses.
//
#define		REG_STATUS			0
#define		REG_INT_MASK		0
#define		REG_DIAG			1
#define		REG_COMMAND			1
#define		REG_ADDR_HI			2
#define		REG_ADDR_LO			3
#define		REG_DATA			4
#define		REG_SUBADR			5
#define		REG_CONFIG			6
#define		REG_SUBVAL			7
//
// Sub-addressed registers.
//
#define		REG_TENTID			0
#define		REG_NODEID			1
#define		REG_SETUP1			2
#define		REG_NEXTID			3
#define		REG_SETUP2			4
#define		REG_BUSCTL			5
#define		REG_DMACNT			6
//
// Structure of data area of each loop tx packet:
//
//	data[0]		Sequence marker byte; starts at '0' and increments (rolling over).
//	data[1]		IP marker byte; last byte of our IP address.
//	data[2]		Low  byte of checksum; data if checksum not used.
//	data[3]		High byte of checksum; data if checksum not used.
//	data...		Data bytes.
//
#define		OFS_SEQUENCE		0
#define		OFS_IPADDR			1
#define		OFS_CHECKSUM		2
#define		OFS_DATA			4
//
// Errors.
//
#define		E_OK				0
#define		E_RECON				1
#define		E_NEW_NEXTID		2
#define		E_EXCNAK			4
#define		E_TIMEOUT			8
#define		E_BADTX				16
//
// Timout periods.
//
#define		RX_EVENT_WAIT		2000
#define		TX_COMPLETE_WAIT	2000
//
// Initialization structures.
//
extern int					gDeviceNumber;
extern int					gDataRate;
extern int					gTimeouts;
extern COM20020_CONFIG		gCfg;
extern SRVR_CONFIG			gSrvrCfg;
extern CString				gHostname;
extern int					gHostPort;
extern bool					gInitialized;
//
//
extern int					gNodeID;
extern struct in_addr		host_ip_address;
//
// Functions.
//
short regRead( unsigned char regNum );
short regWrite( unsigned char regNum , unsigned char val );
short regSubRead( unsigned char regNum );
short regSubWrite( unsigned char regNum , unsigned char val );
void writePacket( FILE *fp , COM20020_RECEIVE_BUFFER *rxb );
void writePacket( FILE *fp , COM20020_TRANSMIT_BUFFER *txb );

#endif