//-----------------------------------------------------------------------------
//
//	Copyright 2000 Contemporary Controls
//
//-----------------------------------------------------------------------------

#ifndef		SCRN_FCN_H
#define		SCRN_FCN_H

//-----------------------------------------------------------------------------
//
//      Routines for screen display.
//      Will either go directly to screen using text mode functions, or will
//      use serial port redirection.
//
//      Assumes upper left corner of screen is 0,0.
//
//-----------------------------------------------------------------------------

// Set this to redirect 'print_str()' to the com port instead of using
// direct text mode screen display functions.
//
#define		REDIRECT	0

// Set this to use ANSI control codes.
//
#define         USE_ANSI        0

// Define pointer to com port if redirection used.
//
#if             REDIRECT
//
#include        "comport.h"
extern          comPort         *scrnCom;
//
// TX & RX buffer sizes.
//
#define	SCRN_TX_SIZE		2048
#define	SCRN_RX_SIZE		2048
//
#endif

// Justification values for 'showStrJ'.
//
#define         J_LEFT          0
#define         J_CENTER        1
#define         J_RIGHT         2

// ----------------------------------------------------------------------------
//
//      ANSI SCREEN CONTROL DEFINES
//
// ----------------------------------------------------------------------------

// Foreground colors.
//
#define		F_BLACK		30
#define		F_RED		31
#define		F_GREEN		32
#define		F_YELLOW	33
#define		F_BLUE		34
#define		F_MAGENTA	35
#define		F_CYAN		36
#define		F_WHITE		37

// Background colors.
//
#define		B_BLACK		40
#define		B_RED		41
#define		B_GREEN		42
#define		B_YELLOW	43
#define		B_BLUE		44
#define		B_MAGENTA	45
#define		B_CYAN		46
#define		B_WHITE		47

// Attributes.
//
#define		A_OFF		0
#define		A_BOLD		1
#define		A_FAINT		2
#define		A_ITALIC	3
#define		A_UNDERSCORE	4
#define		A_BLINK		5
#define		A_RAPID_BLINK	6
#define		A_REVERSE	7
#define		A_CONCEALED	8

#ifdef          __cplusplus
extern "C" {
#endif
// ----------------------------------------------------------------------------
//
//      Screen control functions.
//
// ----------------------------------------------------------------------------

// Prints string to output device; either to screen through text mode functions or
// to com port, depending on value of 'REDIRECT'.
// All other functions in this file call 'print_str()' for output.
//
// NOTE: You must send \n\r instead of just \n to get a real 'carriage return' when
// using ANSI.
//
void printStr( char *buf );

// Prints a specific number of characters from a string.
//
void printStrN( char *buf , int cnt );

// Set foreground, background colors and character modes.
//
void setMode( int fgnd , int bgnd , int attr );

// Position the cursor.
//
void cursor (int x , int y );

// Clear line from cursor to end of line.
//
void clrEol ( void );

// Clear the entire screen
//
void clrScreen (void);

// Clear a line.
//
void clrLine (int y );

// Display a string at x,y pos.
//
void showStr( char *s , int x , int y );

// Display a string at x,y pos with justification.
//
void showStrJ( char *s , int x , int y , int jst );

// Display a subset of string at x,y pos.
//
void showStrN( char *s , int x , int y , int cnt );

#ifdef          __cplusplus
}
#endif

#endif
