//-----------------------------------------------------------------------------
//
//	Copyright 2000 Contemporary Controls
//
//-----------------------------------------------------------------------------

#include	<dos.h>
#include        <conio.h>
#include	<stdio.h>
#include	<string.h>
#include	"scrn_fcn.h"

#if             REDIRECT

// Com port used for screen I/O.
// This will be initialized by the 'main' program.
//
comPort		*scrnCom;

#endif

//-----------------------------------------------------------------------------
// Prints string to output device; either to screen through 'printf()' or
// to com port, depending on value of 'REDIRECT'.
//
void printStr( char *buf )
{
	#if	REDIRECT
	comSendS( scrnCom , buf );	// Console redirection.
	#else
	#if	USE_ANSI
	printf( "%s" , buf );            // Text mode output.
	#else
	cprintf( "%s" , buf );           // Text mode output.
	#endif
	#endif
}

#if             USE_ANSI

// ----------------------------------------------------------------------------
//      ANSI mode screen functions.
// ----------------------------------------------------------------------------

// Set foreground, background colors and character modes.
//
void setMode( int fgnd , int bgnd , int attr )
{
        char	buf[32];

	sprintf( buf , "\x1b[%2.2i;%2.2i;%1.1im", fgnd , bgnd , attr );
	printStr( buf );
}

// Position the cursor.
//
void cursor (int x , int y )
{
	char	buf[32];

	sprintf( buf , "\x1b[%i;%iH" , y + 1 , x + 1 );
	printStr( buf );
}

// Clear line from cursor to end of line.
//
void clrEol ( void )
{
	printStr( "\x1b[K" );
}

// Clear the entire screen
//
void clrScreen (void)
{
	printStr( "\x1b[2J" );
}

// Clear a line.
//
void clrLine (int y )
{
	cursor ( 0 , y );
	clrEol();
}

#else           // !USE_ANSI

// ----------------------------------------------------------------------------
//      Text mode screen functions.
// ----------------------------------------------------------------------------

// Here to convert between ANSI and text mode color definitions.
// Notice that yellow and white are not available as background colors.
//
int     fgndColors[] = { BLACK , RED , GREEN , YELLOW ,    BLUE , MAGENTA , CYAN , WHITE };
int     bgndColors[] = { BLACK , RED , GREEN , LIGHTGRAY , BLUE , MAGENTA , CYAN , LIGHTGRAY };

// Set foreground, background colors and character modes.
// ANSI color codes will be used.
//
void setMode( int fgnd , int bgnd , int attr )
{
        int     i;

        // Set foreground and background.
        i = ( bgndColors[ bgnd - 40 ] << 4 ) + fgndColors[ fgnd - 30 ];
        // 'attr" will set blink.
        if ( attr == A_BLINK ) i |= 0x80;
        // Set mode.
        textattr( i );
}

// Position the cursor.
//
void cursor (int x , int y )
{
        gotoxy( x + 1 , y + 1 );
}

// Clear line from cursor to end of line.
//
void clrEol ( void )
{
        clreol();
}

// Clear the entire screen
//
void clrScreen (void)
{
        clrscr();
}

// Clear a line.
//
void clrLine (int y )
{
        cursor( 0 , y );
        clreol();
}

#endif          // USE_ANSI

// ----------------------------------------------------------------------------
//
//      Routines independent of text/ansi.
//
// ----------------------------------------------------------------------------

// Display a null terminated string at line/col.
//
void showStr (char *buf, int x , int y )
{
	cursor ( x , y );
	printStr( buf );
}

// Display a null terminated string at line/col with justification.
//
void showStrJ (char *buf, int x , int y , int jst )
{
        int     i;

        // Get length of string.
        i = strlen( buf );
        // Which kind of justification?
        switch ( jst )
        {
        case J_LEFT:
           cursor( x , y );
           break;
        case J_CENTER:
           cursor( x - ( i / 2 ) , y );
           break;
        case J_RIGHT:
           cursor( x - i , y );
           break;
        default:
           break;
        }
        printStr( buf );
}

// Display characters from a string at line/col.
//
void showStrN( char *buf , int x , int y , int cnt )
{
	char	s[128];
        char	*p = s;

        // Copy string to buffer.
        strcpy( s , buf );
        // Move through string, put null when 'cnt' characters reached.
        // Bail out if fewer than 'cnt' characters in string.
        while ( *p++ != 0 )
        {
           if ( --cnt == 0 )
           {
              *p = 0;
              break;
           }
        }
        // Print the string.
        showStr( s , x , y );
}

