#pragma		inline

#define		TMR0_CNT_REG	0x50
#define		TMR1_CNT_REG	0x58
#define		TMR2_CNT_REG	0x60

struct {
	unsigned int	hi;
	unsigned int	mid;
	unsigned int	lo;
} time;

void getTime( void )
{
inloop:
	asm	mov	dx,TMR0_CNT_REG
	asm	in 	ax,dx
	asm	mov	time.hi,ax
	asm	mov	dx,TMR1_CNT_REG
	asm	in 	ax,dx
	asm	mov	time.mid,ax
	asm	mov	dx,TMR2_CNT_REG
	asm	in	ax,dx
	asm	mov	time.lo,ax
	asm	in	ax,dx
	if ( _AX < time.lo ) goto inloop;
}

void shiftTime( void )
{
	asm	mov	ax,time.hi
	asm	mov	bx,time.mid
	asm	mov	cx,time.lo
	asm	clc
	asm	ror	ax,1
	asm	ror	bx,1
	asm	ror	cx,1
	asm	sar	ax,1
	asm	ror	bx,1
	asm	ror	cx,1
	asm	sar	ax,1
	asm	ror	bx,1
	asm	ror	cx,1
	asm	mov	time.hi,ax
	asm	mov	time.mid,bx
	asm	mov	time.lo,cx
}

void main( void )
{
	getTime();
	shiftTime();
}


