/** Horizontal padding added to applet size.
 *  @define {number} */
var PAD_H = 15;
/** Vertical padding added to applet size.
 *  @define {number} */
var PAD_V = 115;

/** @type {number} */
var unit_qty = 1;
/** @type {string} */
var unit_number = '1';
/** @type {string} */
var chn_number = '1';
/** @type {string} */
var timestamp;
/** @type {boolean} */
var has_trend = false;

/** @type {FormObject} */
var tabSel1;
/** @type {FormObject} */
var tabSel2;
/** @type {FormObject} */
var tabSel3;
/** @type {FormObject} */
var tabSel4;

/** @type {FormObject} */
var imgCC1;
/** @type {FormObject} */
var imgCC2;
/** @type {FormObject} */
var imgCC3;
/** @type {FormObject} */
var imgCC4;
/** @type {FormObject} */
var imgCC5;
/** @type {FormObject} */
var imgCC6;
/** @type {FormObject} */
var imgCC7;
/** @type {FormObject} */
var imgCC8;

/** @type {FormObject} */
var imgCF1;
/** @type {FormObject} */
var imgCF2;
/** @type {FormObject} */
var imgCF3;
/** @type {FormObject} */
var imgCF4;
/** @type {FormObject} */
var imgCF5;
/** @type {FormObject} */
var imgCF6;
/** @type {FormObject} */
var imgCF7;
/** @type {FormObject} */
var imgCF8;

/** @type {FormObject} */
var btnModmap;
/** @type {FormObject} */
var btnConfig;
/** @type {FormObject} */
var btnModreg;
/** @type {FormObject} */
var btnTime;
/** @type {FormObject} */
var btnEmail;
/** @type {FormObject} */
var btnReset;
/** @type {FormObject} */
var btnTrend;
/** @type {FormObject} */
var btnPassword;
/** @type {FormObject} */
var btnFirmware;

/** @type {FormObject} */
var imgUnitType;
/** @type {FormObject} */
var lblUnitType;

/**
 *  Don't know what kind of object this will be.
 */
var cur_applet_window = null;

function SetTabs()
{
	tabSel2.SetHidden(true);
	tabSel3.SetHidden(true);
	tabSel4.SetHidden(true);

	switch (unit_qty)
	{
	case 1:
		break;
	case 2:
		tabSel2.SetHidden(false);
		break;
	case 3:
		tabSel2.SetHidden(false);
		tabSel3.SetHidden(false);
		break;
	case 4:
		tabSel2.SetHidden(false);
		tabSel3.SetHidden(false);
		tabSel4.SetHidden(false);
		break;
	}
}

function SetUnitImage()
{
	if (unit_number === '1')
	{
		imgUnitType.jqObj.attr('background' , 'images/center_master.jpg');
		lblUnitType.SetValue('Master Unit');
		// Show all buttons.
		btnModmap.SetHidden(false);
		btnModreg.SetHidden(false);
		btnTime.SetHidden(false);
		btnEmail.SetHidden(false);
		btnReset.SetHidden(false);
		if (has_trend)
			btnTrend.SetHidden(false);
		else
			btnTrend.SetHidden(true);
		btnPassword.SetHidden(false);
		btnFirmware.SetHidden(false);
	}
	else
	{
		imgUnitType.jqObj.attr('background' , 'images/center_expansion.jpg');
		lblUnitType.SetValue('Expansion Unit');
		// Hide all buttons.
		btnModmap.SetHidden(true);
		btnModreg.SetHidden(true);
		btnTime.SetHidden(true);
		btnEmail.SetHidden(true);
		btnReset.SetHidden(true);
		btnTrend.SetHidden(true);
		btnPassword.SetHidden(true);
		btnFirmware.SetHidden(true);
	}
}

function SetApplet()
{
	var applet = $('#DivApplet');
	var str;

	str = '<APPLET code="MonitorUnit/MonitorUnitJApplet" archive="monitor-unit-applet-' + timestamp + '.jar" width="788" height="276">';
	str += '<PARAM NAME="UnitNo" VALUE="' + unit_number + '" /></APPLET>';
	$(applet).html(str);
}

/**
 * @param {string} fmoId
 */
function OnClickTab(fmoId)
{
	// Read config file and see how many units we have.
	$.get('bas_unit_qty' , function(data, textStatus, jqXHR)
	{
		var tabID;

		// Get the unit quantity.
		unit_qty = Number(data);

		// Get intended tab number.
		tabID = fmoId.substring(6);

		// If tab is for unit that no longer exists (or is '99'
		// in the case of first load).
		if (Number(tabID) > unit_qty)
		{
			// Move to unit 1.
			unit_number = '1';
		}
		// Else good tab number.
		else
		{
			unit_number = tabID;
		}

		// Show/hide tabls.
		SetTabs();

		// Show proper unit image.
		SetUnitImage();

		// Load the proper applet.
		SetApplet();

		// Enable the proper tab.
		var bod = $('body');
		var newid = 'tab' + unit_number;
		$(bod).attr('id' , newid);

		// Bring the focus back to the configuration window.
		if (cur_applet_window !== null)
			cur_applet_window.focus();
	});
}

/**
 * Open a new applet window. If an applet has already been opened,
 * it closes that window before opening another.
 *
 * The name, width, and height all refer to the applet being opened.
 * We add PAD_H and PAD_V to the applet dimensions to get the window size.
 *
 * @param {string} name
 * @param {number} width
 * @param {number} height
 */
function NewAppWindow(name , width , height)
{
	/** @type {string} */
	var str;
	/** @type {number} */
	var w = width + PAD_H;
	/** @type {number} */
	var h = height + PAD_V;

	// Close an already opened applet window.
	if (cur_applet_window !== null)
		cur_applet_window.close();

	window['app_name'] = name;
	window['app_width'] = width.toString();
	window['app_height'] = height.toString();
	str = 'width=' + w.toString() + ',height=' + h.toString() + ',status=yes,resizable=no';
	// Open the window.
	cur_applet_window = window.open('app-common.html', 'Default', str);
	// Save it so the opened window can set it to 'null' when it closes.
	window['cur_applet_window'] = cur_applet_window;
}

function OnClickButton(fmoId)
{
	/** @type {number} */
	var width;
	/** @type {number} */
	var height;
	/** @type {string} */
	var name;
	/** @type {string} */
	var str;

	switch (fmoId)
	{
	case 'BtnModmap':
		name = 'modbus-mapping-applet';
		width = 835;
		height = 445;
		break;
	case 'BtnConfig':
		window['unit_number'] = unit_number;
		if (unit_number === '1')
		{
			name = 'config-unit-applet';
			width = 445;
			height = 430;
		}
		else
		{
			name = 'config-exp-unit-applet';
			width = 445;
			height = 140;
		}
		break;
	case 'BtnModreg':
		name = 'modreg-applet';
		width = 480;
		height = 350;
		break;
	case 'BtnTime':
		name = 'time-set-applet';
		width = 660;			// Orig 450
		height = 600;			// Orig 200
		break;
	case 'BtnEmail':
		name = 'email-applet';
		width = 450;
		height = 450;
		break;
	}

	NewAppWindow(name , width , height);
}

function OnClickConfig(fmoId)
{
	chn_number = fmoId.substring(5);
	window['chn_number'] = chn_number;
	window['unit_number'] = unit_number;
	NewAppWindow('config-channel-applet' , 590 , 390);
}

function OnClickForce(fmoId)
{
	chn_number = fmoId.substring(5);
	window['chn_number'] = chn_number;
	window['unit_number'] = unit_number;
	NewAppWindow('monitor-channel-applet' , 545 , 155);
}

function FinishLoad()
{

	imgCC1 = new FormObject(fmoType.Button , 'ImgCC1');
	imgCC2 = new FormObject(fmoType.Button , 'ImgCC2');
	imgCC3 = new FormObject(fmoType.Button , 'ImgCC3');
	imgCC4 = new FormObject(fmoType.Button , 'ImgCC4');
	imgCC5 = new FormObject(fmoType.Button , 'ImgCC5');
	imgCC6 = new FormObject(fmoType.Button , 'ImgCC6');
	imgCC7 = new FormObject(fmoType.Button , 'ImgCC7');
	imgCC8 = new FormObject(fmoType.Button , 'ImgCC8');

	imgCC1.SetOnclickHandler(OnClickConfig);
	imgCC2.SetOnclickHandler(OnClickConfig);
	imgCC3.SetOnclickHandler(OnClickConfig);
	imgCC4.SetOnclickHandler(OnClickConfig);
	imgCC5.SetOnclickHandler(OnClickConfig);
	imgCC6.SetOnclickHandler(OnClickConfig);
	imgCC7.SetOnclickHandler(OnClickConfig);
	imgCC8.SetOnclickHandler(OnClickConfig);

	imgCF1 = new FormObject(fmoType.Button , 'ImgCF1');
	imgCF2 = new FormObject(fmoType.Button , 'ImgCF2');
	imgCF3 = new FormObject(fmoType.Button , 'ImgCF3');
	imgCF4 = new FormObject(fmoType.Button , 'ImgCF4');
	imgCF5 = new FormObject(fmoType.Button , 'ImgCF5');
	imgCF6 = new FormObject(fmoType.Button , 'ImgCF6');
	imgCF7 = new FormObject(fmoType.Button , 'ImgCF7');
	imgCF8 = new FormObject(fmoType.Button , 'ImgCF8');

	imgCF1.SetOnclickHandler(OnClickForce);
	imgCF2.SetOnclickHandler(OnClickForce);
	imgCF3.SetOnclickHandler(OnClickForce);
	imgCF4.SetOnclickHandler(OnClickForce);
	imgCF5.SetOnclickHandler(OnClickForce);
	imgCF6.SetOnclickHandler(OnClickForce);
	imgCF7.SetOnclickHandler(OnClickForce);
	imgCF8.SetOnclickHandler(OnClickForce);

	btnModmap = new FormObject(fmoType.Button , 'BtnModmap');
	btnConfig = new FormObject(fmoType.Button , 'BtnConfig');
	btnModreg = new FormObject(fmoType.Button , 'BtnModreg');
	btnTime = new FormObject(fmoType.Button , 'BtnTime');
	btnEmail = new FormObject(fmoType.Button , 'BtnEmail');
	btnReset = new FormObject(fmoType.Button , 'BtnReset');
	btnTrend = new FormObject(fmoType.Button , 'BtnTrend');
	btnPassword = new FormObject(fmoType.Button , 'BtnPassword');
	btnFirmware = new FormObject(fmoType.Button , 'BtnFirmware')

	btnModmap.SetOnclickHandler(OnClickButton);
	btnConfig.SetOnclickHandler(OnClickButton);
	btnModreg.SetOnclickHandler(OnClickButton);
	btnTime.SetOnclickHandler(OnClickButton);
	btnEmail.SetOnclickHandler(OnClickButton);

	lblUnitType = new FormObject(fmoType.Label , 'LblUnitType');
	imgUnitType = new FormObject(fmoType.Image , 'ImgUnitType');
}

$(document).ready(function()
{
	// Make sure IE doesn't cache.
	$.ajaxSetup ({cache: false});

//	var params = this.documentURI;

	tabSel1 = new FormObject(fmoType.Button , 'TabSel1');
	tabSel2 = new FormObject(fmoType.Button , 'TabSel2');
	tabSel3 = new FormObject(fmoType.Button , 'TabSel3');
	tabSel4 = new FormObject(fmoType.Button , 'TabSel4');

	tabSel1.SetOnclickHandler(OnClickTab);
	tabSel2.SetOnclickHandler(OnClickTab);
	tabSel3.SetOnclickHandler(OnClickTab);
	tabSel4.SetOnclickHandler(OnClickTab);

	// Hide all tabs except the first until we know how many
	// units we have.
	SetTabs();

	// Get timestamp.
	$.get('timestamp' , function(data, textStatus, jqXHR)
	{
		timestamp = data.substr(0 , data.length - 1);

		// See if we have the trend server.
		$.get('has_trend' , function(data, textStatus, jqXHR)
		{
			var dchar = data.substr(0 , data.length - 1);

			has_trend = (dchar === 'y');

			// Finish the load.
			FinishLoad();

			// Insure that we select tab1 by specifying a "new" tab
			// that is greater than the number of units.
			OnClickTab('TabSel99');

//			// Set up timer to periodically check on the number of bas units
//			// and update the tab display if it changes.
//			setInterval(function()
//			{
//				$.get('bas_unit_qty' , function(data, textStatus, jqXHR)
//				{
//					var buq = Number(data);
//					if (buq != unit_qty)
//					{
//						unit_qty = buq;
//						OnClickTab('TabSel99');
//					}
//				});
//			} , 1000);

			// Set access point for children.
			window['unit_number'] = unit_number;
			window['chn_number'] = chn_number;
			window['timestamp'] = timestamp;
		});
	});
});
